/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import java.io.IOException;

final class SimpleObjectDeserializer
implements Deserializer<Object>,
UpdatingDeserializer<Object> {
    private final boolean ignoreUnknown;
    private final boolean strictNullable;
    private final BeanIntrospection<Object> introspection;
    private final PropertiesBag<Object> properties;
    @Nullable
    private final SerdeDeserializationPreInstantiateCallback preInstantiateCallback;

    SimpleObjectDeserializer(boolean ignoreUnknown, boolean strictNullable, DeserBean<? super Object> deserBean, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.ignoreUnknown = ignoreUnknown && deserBean.ignoreUnknown;
        this.strictNullable = strictNullable;
        this.introspection = deserBean.introspection;
        this.properties = deserBean.readProperties;
        this.preInstantiateCallback = preInstantiateCallback;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType) throws IOException {
        Object obj;
        try {
            if (this.preInstantiateCallback != null) {
                this.preInstantiateCallback.preInstantiate(this.introspection, ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
            obj = this.introspection.instantiate(this.strictNullable, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
        catch (InstantiationException e) {
            throw new SerdeException("Unable to deserialize type [" + beanType + "]: " + e.getMessage(), e);
        }
        this.deserializeInto(decoder, decoderContext, beanType, obj);
        return obj;
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    @Override
    public void deserializeInto(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType, Object beanInstance) throws IOException {
        Decoder objectDecoder = decoder.decodeObject(beanType);
        if (this.properties != null) {
            String prop;
            PropertiesBag.Consumer propertiesConsumer = this.properties.newConsumer();
            boolean allConsumed = false;
            while (!allConsumed && (prop = objectDecoder.decodeKey()) != null) {
                DeserBean.DerProperty consumedProperty = propertiesConsumer.consume(prop);
                if (consumedProperty != null) {
                    consumedProperty.deserializeAndSetPropertyValue(objectDecoder, decoderContext, beanInstance);
                    allConsumed = propertiesConsumer.isAllConsumed();
                    continue;
                }
                if (this.ignoreUnknown) {
                    objectDecoder.skipValue();
                    continue;
                }
                throw this.unknownProperty(beanType, prop);
            }
            if (!allConsumed) {
                for (DeserBean.DerProperty dp : propertiesConsumer.getNotConsumed()) {
                    dp.setDefaultPropertyValue(decoderContext, beanInstance);
                }
            }
        }
        if (this.ignoreUnknown) {
            objectDecoder.finishStructure(true);
        } else {
            String unknownProp = objectDecoder.decodeKey();
            if (unknownProp != null) {
                throw this.unknownProperty(beanType, unknownProp);
            }
            objectDecoder.finishStructure();
        }
    }

    private SerdeException unknownProperty(Argument<? super Object> beanType, String prop) {
        return new SerdeException("Unknown property [" + prop + "] encountered during deserialization of type: " + beanType);
    }
}

