/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator.client;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.StaticServiceInstanceList;
import io.micronaut.health.HealthStatus;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.reactivestreams.Publisher;

@EachBean(value=ServiceHttpClientConfiguration.class)
@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(classes={ServiceHttpClientConfiguration.class}), @Requires(property="endpoints.health.service-http-client.enabled", defaultValue="false", notEquals="false")})
public class ServiceHttpClientHealthIndicator
implements HealthIndicator {
    private final ServiceHttpClientConfiguration configuration;
    private final Collection<URI> loadBalancerUrls;
    private final Collection<URI> originalUrls;
    private final HealthResult.Builder serviceHealthBuilder;

    public ServiceHttpClientHealthIndicator(@Parameter ServiceHttpClientConfiguration configuration, @Parameter StaticServiceInstanceList instanceList) {
        this.configuration = configuration;
        this.loadBalancerUrls = instanceList.getLoadBalancedURIs();
        this.originalUrls = configuration.getUrls();
        this.serviceHealthBuilder = HealthResult.builder(configuration.getServiceId());
    }

    @Override
    public Publisher<HealthResult> getResult() {
        if (!this.configuration.isHealthCheck()) {
            return Publishers.empty();
        }
        return Publishers.just(this.determineServiceHealth());
    }

    private HealthResult determineServiceHealth() {
        LinkedHashMap<String, Collection<URI>> details = new LinkedHashMap<String, Collection<URI>>(2);
        details.put("all_urls", this.originalUrls);
        details.put("available_urls", this.loadBalancerUrls);
        if (this.loadBalancerUrls.isEmpty()) {
            return this.serviceHealthBuilder.status(HealthStatus.DOWN).details(details).build();
        }
        return this.serviceHealthBuilder.status(HealthStatus.UP).details(details).build();
    }
}

