/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.core.tree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.micronaut.jackson.core.tree.JsonNodeTraversingParser;
import io.micronaut.jackson.core.tree.TreeGenerator;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsonNodeTreeCodec {
    private static final JsonNodeTreeCodec INSTANCE = new JsonNodeTreeCodec(JsonStreamConfig.DEFAULT);
    private final JsonStreamConfig config;

    private JsonNodeTreeCodec(JsonStreamConfig config) {
        this.config = config;
    }

    public static JsonNodeTreeCodec getInstance() {
        return INSTANCE;
    }

    public JsonNodeTreeCodec withConfig(JsonStreamConfig config) {
        return new JsonNodeTreeCodec(config);
    }

    public JsonNode readTree(JsonParser p) throws IOException {
        switch (p.hasCurrentToken() ? p.currentToken() : p.nextToken()) {
            case START_OBJECT: {
                LinkedHashMap<String, JsonNode> map = new LinkedHashMap<String, JsonNode>();
                while (p.nextToken() != JsonToken.END_OBJECT) {
                    String name = p.currentName();
                    p.nextToken();
                    map.put(name, this.readTree(p));
                }
                return JsonNode.createObjectNode(map);
            }
            case START_ARRAY: {
                ArrayList<JsonNode> list = new ArrayList<JsonNode>();
                while (p.nextToken() != JsonToken.END_ARRAY) {
                    list.add(this.readTree(p));
                }
                return JsonNode.createArrayNode(list);
            }
            case VALUE_STRING: {
                return JsonNode.createStringNode(p.getText());
            }
            case VALUE_NUMBER_INT: {
                if (this.config.useBigIntegerForInts()) {
                    return JsonNode.createNumberNode(p.getBigIntegerValue());
                }
                return JsonNode.createNumberNodeImpl(p.getNumberValue());
            }
            case VALUE_NUMBER_FLOAT: {
                if (this.config.useBigDecimalForFloats()) {
                    if (p.isNaN()) {
                        return JsonNode.createNumberNode(p.getFloatValue());
                    }
                    return JsonNode.createNumberNode(p.getDecimalValue());
                }
                return JsonNode.createNumberNodeImpl(p.getNumberValue());
            }
            case VALUE_TRUE: {
                return JsonNode.createBooleanNode(true);
            }
            case VALUE_FALSE: {
                return JsonNode.createBooleanNode(false);
            }
            case VALUE_NULL: {
                return JsonNode.nullNode();
            }
        }
        throw new UnsupportedOperationException("Unsupported token: " + p.currentToken());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTree(JsonGenerator generator, JsonNode tree) throws IOException {
        if (tree.isObject()) {
            generator.writeStartObject();
            for (Map.Entry<String, JsonNode> entry : tree.entries()) {
                generator.writeFieldName(entry.getKey());
                this.writeTree(generator, entry.getValue());
            }
            generator.writeEndObject();
            return;
        } else if (tree.isArray()) {
            generator.writeStartArray();
            for (JsonNode value : tree.values()) {
                this.writeTree(generator, value);
            }
            generator.writeEndArray();
            return;
        } else if (tree.isBoolean()) {
            generator.writeBoolean(tree.getBooleanValue());
            return;
        } else if (tree.isNull()) {
            generator.writeNull();
            return;
        } else if (tree.isNumber()) {
            Number value = tree.getNumberValue();
            if (value instanceof Integer) {
                generator.writeNumber(value.intValue());
                return;
            } else if (value instanceof Long) {
                generator.writeNumber(value.longValue());
                return;
            } else if (value instanceof Double) {
                generator.writeNumber(value.doubleValue());
                return;
            } else if (value instanceof Float) {
                generator.writeNumber(value.floatValue());
                return;
            } else if (value instanceof BigDecimal) {
                generator.writeNumber((BigDecimal)value);
                return;
            } else if (value instanceof Byte || value instanceof Short) {
                generator.writeNumber(value.shortValue());
                return;
            } else {
                if (!(value instanceof BigInteger)) throw new IllegalStateException("Unknown number type " + value.getClass().getName());
                generator.writeNumber((BigInteger)value);
            }
            return;
        } else {
            if (!tree.isString()) throw new AssertionError();
            generator.writeString(tree.getStringValue());
        }
    }

    public JsonParser treeAsTokens(JsonNode node) {
        return new JsonNodeTraversingParser(node);
    }

    public TreeGenerator createTreeGenerator() {
        return new TreeGenerator();
    }
}

