/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.core.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;

@Internal
public final class JacksonCoreParserFactory {
    private static final boolean HAS_NETTY_BUFFER;

    private JacksonCoreParserFactory() {
    }

    public static JsonParser createJsonParser(JsonFactory factory, ByteBuffer<?> buffer) throws IOException {
        Object obj;
        if (!HAS_NETTY_BUFFER || !((obj = buffer.asNativeBuffer()) instanceof ByteBuf)) {
            return factory.createParser(buffer.toByteArray());
        }
        ByteBuf byteBuf = (ByteBuf)obj;
        if (byteBuf.hasArray()) {
            return factory.createParser(byteBuf.array(), byteBuf.readerIndex() + byteBuf.arrayOffset(), byteBuf.readableBytes());
        }
        return factory.createParser(new ByteBufInputStream(byteBuf));
    }

    static {
        boolean hasNettyBuffer;
        try {
            Class.forName("io.netty.buffer.ByteBuf", false, JacksonCoreParserFactory.class.getClassLoader());
            hasNettyBuffer = true;
        }
        catch (ClassNotFoundException e) {
            hasNettyBuffer = false;
        }
        HAS_NETTY_BUFFER = hasNettyBuffer;
    }
}

