/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Configuration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.annotation.Type;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueProvider;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.Indexes;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectionConfig;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotationMetadataException;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class AnnotationMetadataSupport {
    private static final Map<String, Map<CharSequence, Object>> ANNOTATION_DEFAULTS = new ConcurrentHashMap<String, Map<CharSequence, Object>>(20);
    private static final Map<String, String> REPEATABLE_ANNOTATIONS_CONTAINERS = new ConcurrentHashMap<String, String>(20);
    private static final Map<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>> ANNOTATION_PROXY_CACHE = new ConcurrentHashMap<Class<? extends Annotation>, Optional<Constructor<InvocationHandler>>>(20);
    private static final Map<String, Class<? extends Annotation>> ANNOTATION_TYPES = new ConcurrentHashMap<String, Class<? extends Annotation>>(20);

    @Internal
    public static List<Map.Entry<Class<? extends Annotation>, Class<? extends Annotation>>> getCoreRepeatableAnnotations() {
        return Arrays.asList(new AbstractMap.SimpleEntry<Class<Indexed>, Class<Indexes>>(Indexed.class, Indexes.class), new AbstractMap.SimpleEntry<Class<Requires>, Class<Requirements>>(Requires.class, Requirements.class), new AbstractMap.SimpleEntry<Class<AliasFor>, Class<Aliases>>(AliasFor.class, Aliases.class), new AbstractMap.SimpleEntry<Class<Property>, Class<PropertySource>>(Property.class, PropertySource.class), new AbstractMap.SimpleEntry<Class<ReflectionConfig>, Class<ReflectionConfig.ReflectionConfigList>>(ReflectionConfig.class, ReflectionConfig.ReflectionConfigList.class));
    }

    @NonNull
    public static Map<CharSequence, Object> getDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.getOrDefault(annotation, Collections.emptyMap());
    }

    @Nullable
    public static Map<CharSequence, Object> getDefaultValuesOrNull(String annotation) {
        return ANNOTATION_DEFAULTS.get(annotation);
    }

    @Internal
    public static String getRepeatableAnnotation(String annotation) {
        return REPEATABLE_ANNOTATIONS_CONTAINERS.get(annotation);
    }

    static Optional<Class<? extends Annotation>> getAnnotationType(String name) {
        return AnnotationMetadataSupport.getAnnotationType(name, AnnotationMetadataSupport.class.getClassLoader());
    }

    static Optional<Class<? extends Annotation>> getAnnotationType(String name, ClassLoader classLoader) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        Class aClass = ClassUtils.forName(name, classLoader).orElse(null);
        if (aClass != null && Annotation.class.isAssignableFrom(aClass)) {
            ANNOTATION_TYPES.put(name, aClass);
            return Optional.of(aClass);
        }
        return Optional.empty();
    }

    static Optional<Class<? extends Annotation>> getRegisteredAnnotationType(String name) {
        Class<? extends Annotation> type = ANNOTATION_TYPES.get(name);
        if (type != null) {
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static Map<CharSequence, Object> getDefaultValues(Class<? extends Annotation> annotation) {
        return AnnotationMetadataSupport.getDefaultValues(annotation.getName());
    }

    static boolean hasDefaultValues(String annotation) {
        return ANNOTATION_DEFAULTS.containsKey(annotation);
    }

    static void registerDefaultValues(String annotation, Map<CharSequence, Object> defaultValues) {
        if (StringUtils.isNotEmpty(annotation)) {
            ANNOTATION_DEFAULTS.put(annotation, defaultValues);
        }
    }

    static void registerDefaultValues(AnnotationClassValue<?> annotation, Map<CharSequence, Object> defaultValues) {
        if (defaultValues != null) {
            AnnotationMetadataSupport.registerDefaultValues(annotation.getName(), defaultValues);
        }
        AnnotationMetadataSupport.registerAnnotationType(annotation);
    }

    static void registerAnnotationType(AnnotationClassValue<?> annotationClassValue) {
        Class aClass;
        String name = annotationClassValue.getName();
        if (!ANNOTATION_TYPES.containsKey(name) && (aClass = (Class)annotationClassValue.getType().orElse(null)) != null && Annotation.class.isAssignableFrom(aClass)) {
            ANNOTATION_TYPES.put(name, aClass);
        }
    }

    @Internal
    static void registerRepeatableAnnotations(Map<String, String> repeatableAnnotations) {
        REPEATABLE_ANNOTATIONS_CONTAINERS.putAll(repeatableAnnotations);
    }

    @Internal
    static void registerRepeatableAnnotation(@NonNull String repeatable, @NonNull String repeatableContainer) {
        REPEATABLE_ANNOTATIONS_CONTAINERS.put(repeatable, repeatableContainer);
    }

    static Optional<Constructor<InvocationHandler>> getProxyClass(Class<? extends Annotation> annotation) {
        return ANNOTATION_PROXY_CACHE.computeIfAbsent(annotation, aClass -> {
            Class<?> proxyClass = Proxy.getProxyClass(annotation.getClassLoader(), annotation, AnnotationValueProvider.class);
            return ReflectionUtils.findConstructor(proxyClass, InvocationHandler.class);
        });
    }

    @Internal
    public static <T extends Annotation> T buildAnnotation(Class<T> annotationClass, @Nullable AnnotationValue<T> annotationValue) {
        Optional<Constructor<InvocationHandler>> proxyClass = AnnotationMetadataSupport.getProxyClass(annotationClass);
        if (proxyClass.isPresent()) {
            HashMap<CharSequence, Object> values = new HashMap<CharSequence, Object>(AnnotationMetadataSupport.getDefaultValues(annotationClass));
            if (annotationValue != null) {
                Map<CharSequence, Object> annotationValues = annotationValue.getValues();
                annotationValues.forEach((key, o) -> values.put(key.toString(), o));
            }
            int hashCode = AnnotationUtil.calculateHashCode(values);
            Optional<InvocationHandler> instantiated = InstantiationUtils.tryInstantiate(proxyClass.get(), new AnnotationProxyHandler<T>(hashCode, annotationClass, annotationValue));
            if (instantiated.isPresent()) {
                return (T)((Annotation)((Object)instantiated.get()));
            }
        }
        throw new AnnotationMetadataException("Failed to build annotation for type: " + annotationClass.getName());
    }

    static {
        Arrays.asList(Nullable.class, NonNull.class, PreDestroy.class, PostConstruct.class, Named.class, Singleton.class, Inject.class, Qualifier.class, Scope.class, Prototype.class, Executable.class, Bean.class, Primary.class, Value.class, Property.class, Provided.class, Requires.class, Secondary.class, Type.class, Context.class, EachBean.class, EachProperty.class, Configuration.class, ConfigurationProperties.class, ConfigurationBuilder.class, Introspected.class, Parameter.class, Replaces.class, Requirements.class, Factory.class).forEach(ann -> ANNOTATION_TYPES.put(ann.getName(), (Class<? extends Annotation>)ann));
        for (Map.Entry<Class<? extends Annotation>, Class<? extends Annotation>> e : AnnotationMetadataSupport.getCoreRepeatableAnnotations()) {
            REPEATABLE_ANNOTATIONS_CONTAINERS.put(e.getKey().getName(), e.getValue().getName());
        }
        REPEATABLE_ANNOTATIONS_CONTAINERS.put("io.micronaut.aop.InterceptorBinding", "io.micronaut.aop.InterceptorBindingDefinitions");
    }

    private static class AnnotationProxyHandler<A extends Annotation>
    implements InvocationHandler,
    AnnotationValueProvider<A> {
        private final int hashCode;
        private final Class<A> annotationClass;
        private final AnnotationValue<A> annotationValue;

        AnnotationProxyHandler(int hashCode, Class<A> annotationClass, @Nullable AnnotationValue<A> annotationValue) {
            this.hashCode = hashCode;
            this.annotationClass = annotationClass;
            this.annotationValue = annotationValue;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.annotationClass.isInstance(obj)) {
                return false;
            }
            Annotation other = (Annotation)this.annotationClass.cast(obj);
            AnnotationValue<?> otherValues = this.getAnnotationValues(other);
            if (this.annotationValue == null && otherValues == null) {
                return true;
            }
            if (this.annotationValue == null || otherValues == null) {
                return false;
            }
            return this.annotationValue.equals(otherValues);
        }

        private AnnotationValue<?> getAnnotationValues(Annotation other) {
            if (other instanceof AnnotationProxyHandler) {
                return ((AnnotationProxyHandler)((Object)other)).annotationValue;
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name = method.getName();
            if ((args == null || args.length == 0) && "hashCode".equals(name)) {
                return this.hashCode;
            }
            if (args != null && args.length == 1 && "equals".equals(name)) {
                return this.equals(args[0]);
            }
            if ("annotationType".equals(name)) {
                return this.annotationClass;
            }
            if (method.getReturnType() == AnnotationValue.class) {
                return this.annotationValue;
            }
            if (this.annotationValue != null && this.annotationValue.contains(name)) {
                return this.annotationValue.getRequiredValue(name, method.getReturnType());
            }
            return method.getDefaultValue();
        }

        @Override
        @NonNull
        public AnnotationValue<A> annotationValue() {
            if (this.annotationValue != null) {
                return this.annotationValue;
            }
            return new AnnotationValue(this.annotationClass.getName());
        }
    }
}

