/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.discovery;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.discovery.event.ServiceStoppedEvent;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.discovery.NettyEmbeddedServerInstance;
import io.micronaut.runtime.event.annotation.EventListener;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import jakarta.inject.Singleton;

@Singleton
@Internal
@Requires(classes={ServiceInstance.class})
final class NettyServiceDiscovery {
    private final ApplicationEventPublisher<ServiceReadyEvent> serviceReadyEventApplicationEventPublisher;
    private final ApplicationEventPublisher<ServiceStoppedEvent> serviceStoppedEventApplicationEventPublisher;
    private NettyEmbeddedServerInstance createdInstance;

    NettyServiceDiscovery(ApplicationEventPublisher<ServiceReadyEvent> serviceReadyEventApplicationEventPublisher, ApplicationEventPublisher<ServiceStoppedEvent> serviceStoppedEventApplicationEventPublisher) {
        this.serviceReadyEventApplicationEventPublisher = serviceReadyEventApplicationEventPublisher;
        this.serviceStoppedEventApplicationEventPublisher = serviceStoppedEventApplicationEventPublisher;
    }

    @EventListener
    void onStart(ServerStartupEvent event) {
        NettyEmbeddedServer nettyEmbeddedServer;
        NettyEmbeddedServerInstance instance;
        EmbeddedServer embeddedServer = event.getSource();
        if (embeddedServer instanceof NettyEmbeddedServer && (instance = this.getInstance(nettyEmbeddedServer = (NettyEmbeddedServer)embeddedServer)) != null) {
            this.serviceReadyEventApplicationEventPublisher.publishEvent(new ServiceReadyEvent(instance));
        }
    }

    @EventListener
    void onStop(ServerShutdownEvent event) {
        NettyEmbeddedServer nettyEmbeddedServer;
        NettyEmbeddedServerInstance instance;
        EmbeddedServer embeddedServer = event.getSource();
        if (embeddedServer instanceof NettyEmbeddedServer && (instance = this.getInstance(nettyEmbeddedServer = (NettyEmbeddedServer)embeddedServer)) != null) {
            this.serviceStoppedEventApplicationEventPublisher.publishEvent(new ServiceStoppedEvent(instance));
        }
    }

    @Nullable
    private NettyEmbeddedServerInstance getInstance(NettyEmbeddedServer nettyEmbeddedServer) {
        if (this.createdInstance == null) {
            ApplicationContext applicationContext = nettyEmbeddedServer.getApplicationContext();
            nettyEmbeddedServer.getApplicationConfiguration().getName().ifPresent(id -> {
                this.createdInstance = applicationContext.createBean(NettyEmbeddedServerInstance.class, id, nettyEmbeddedServer);
            });
        }
        return this.createdInstance;
    }
}

