/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.binders.NettyBodyAnnotationBinder;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import io.micronaut.http.server.netty.converters.NettyConverters;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Internal
final class NettyPublisherBodyBinder
implements NonBlockingBodyArgumentBinder<Publisher<?>> {
    public static final String MSG_CONVERT_DEBUG = "Cannot convert message for argument [{}] and value: {}";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private static final Argument<Publisher<?>> TYPE = Argument.of(Publisher.class);
    private final NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder;

    NettyPublisherBodyBinder(NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder) {
        this.nettyBodyAnnotationBinder = nettyBodyAnnotationBinder;
    }

    @Override
    public Argument<Publisher<?>> argumentType() {
        return TYPE;
    }

    @Override
    public ArgumentBinder.BindingResult<Publisher<?>> bind(ArgumentConversionContext<Publisher<?>> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            MessageBodyReader<Object> messageBodyReader;
            Optional<MessageBodyReader<Object>> reader;
            ImmediateByteBody imm;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            ByteBody rootBody = nhr.byteBody();
            if (rootBody instanceof ImmediateByteBody && (imm = (ImmediateByteBody)rootBody).empty()) {
                return ArgumentBinder.BindingResult.empty();
            }
            Argument<Object> targetType = context.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            MediaType mediaType = nhr.getContentType().orElse(null);
            if (!Publishers.isSingle(context.getArgument().getType()) && !context.getArgument().isSpecifiedSingle() && mediaType != null && (reader = this.nettyBodyAnnotationBinder.bodyHandlerRegistry.findReader(targetType, List.of(mediaType))).isPresent() && (messageBodyReader = reader.get()) instanceof ChunkedMessageBodyReader) {
                ChunkedMessageBodyReader piecewise = (ChunkedMessageBodyReader)messageBodyReader;
                Publisher<Object> pub = piecewise.readChunked(targetType, mediaType, nhr.getHeaders(), Flux.from(rootBody.rawContent(this.nettyBodyAnnotationBinder.httpServerConfiguration).asPublisher()).map(b -> NettyByteBufferFactory.DEFAULT.wrap((ByteBuf)b)));
                return () -> Optional.of(pub);
            }
            ExecutionFlow<Object> flow = rootBody.buffer(nhr.getChannelHandlerContext().alloc()).map(bytes -> {
                Optional<Object> value;
                try {
                    value = this.nettyBodyAnnotationBinder.transform(nhr, context.with(targetType), (ImmediateByteBody)bytes);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return value.orElseThrow(() -> NettyPublisherBodyBinder.extractError(null, context));
            });
            Publisher future = ReactiveExecutionFlow.toPublisher(() -> flow);
            return () -> Optional.of(future);
        }
        return ArgumentBinder.BindingResult.empty();
    }

    static RuntimeException extractError(Object message, ArgumentConversionContext<?> conversionContext) {
        Optional<ConversionError> lastError = conversionContext.getLastError();
        if (lastError.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(MSG_CONVERT_DEBUG, (Object)conversionContext.getArgument(), (Object)lastError.get());
            }
            return new ConversionErrorException(conversionContext.getArgument(), lastError.get());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MSG_CONVERT_DEBUG, (Object)conversionContext.getArgument(), message);
        }
        return UnsatisfiedRouteException.create(conversionContext.getArgument());
    }

    static Object convertAndRelease(ConversionService conversionService, ArgumentConversionContext<?> conversionContext, Object o) {
        Optional<?> converted;
        ByteBufHolder holder;
        if (o instanceof ByteBufHolder && !((ByteBuf)(o = (holder = (ByteBufHolder)o).content())).isReadable()) {
            return null;
        }
        if (o instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)o;
            converted = NettyConverters.refCountAwareConvert(conversionService, rc, conversionContext);
        } else {
            converted = conversionService.convert(o, conversionContext);
        }
        if (converted.isPresent()) {
            return converted.get();
        }
        throw NettyPublisherBodyBinder.extractError(o, conversionContext);
    }
}

