/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseFactory;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.ServerAttributeKeys;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.Attribute;
import java.util.Optional;

@Internal
public class NettyHttpResponseFactory
implements HttpResponseFactory {
    @Override
    public <T> MutableHttpResponse<T> ok(T body) {
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, body, ConversionService.SHARED);
    }

    @Override
    public <T> MutableHttpResponse<T> status(HttpStatus status, T body) {
        return this.ok(body).status(status);
    }

    public MutableHttpResponse status(HttpStatus status, String reason) {
        HttpResponseStatus nettyStatus = reason == null ? HttpResponseStatus.valueOf(status.getCode()) : HttpResponseStatus.valueOf(status.getCode(), reason);
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, ConversionService.SHARED);
    }

    @Override
    public <T> MutableHttpResponse<T> status(int status, String reason) {
        HttpResponseStatus nettyStatus = reason == null ? HttpResponseStatus.valueOf(status) : HttpResponseStatus.valueOf(status, reason);
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, ConversionService.SHARED);
    }

    @Internal
    public static NettyMutableHttpResponse getOrCreate(NettyHttpRequest<?> request) {
        return NettyHttpResponseFactory.getOr(request, HttpResponse.ok());
    }

    @Internal
    public static NettyMutableHttpResponse getOr(NettyHttpRequest<?> request, HttpResponse<?> alternative) {
        Attribute<NettyMutableHttpResponse> attr = request.attr(ServerAttributeKeys.RESPONSE_KEY);
        NettyMutableHttpResponse nettyHttpResponse = attr.get();
        if (nettyHttpResponse == null) {
            nettyHttpResponse = (NettyMutableHttpResponse)alternative;
            attr.set(nettyHttpResponse);
        }
        return nettyHttpResponse;
    }

    @Internal
    public static Optional<NettyMutableHttpResponse> get(NettyHttpRequest<?> request) {
        NettyMutableHttpResponse nettyHttpResponse = request.attr(ServerAttributeKeys.RESPONSE_KEY).get();
        return Optional.ofNullable(nettyHttpResponse);
    }

    @Internal
    public static Optional<NettyMutableHttpResponse> set(NettyHttpRequest<?> request, HttpResponse<?> response) {
        request.attr(ServerAttributeKeys.RESPONSE_KEY).set((NettyMutableHttpResponse)response);
        return Optional.ofNullable((NettyMutableHttpResponse)response);
    }
}

