/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.BodyArgumentBinder;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class DefaultBodyAnnotationBinder<T>
extends AbstractArgumentBinder<T>
implements BodyArgumentBinder<T> {
    protected final ConversionService conversionService;

    public DefaultBodyAnnotationBinder(ConversionService conversionService) {
        super(conversionService);
        this.conversionService = conversionService;
    }

    @Override
    public final Class<Body> getAnnotationType() {
        return Body.class;
    }

    @Override
    public final ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        if (!source.getMethod().permitsRequestBody()) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        boolean annotatedAsBody = context.getAnnotationMetadata().hasAnnotation(Body.class);
        Optional<String> optionalBodyComponent = context.getAnnotationMetadata().stringValue(Body.class);
        String bodyComponent = optionalBodyComponent.orElseGet(() -> {
            if (annotatedAsBody) {
                return null;
            }
            return context.getArgument().getName();
        });
        if (bodyComponent != null) {
            return this.bindBodyPart(context, source, bodyComponent);
        }
        return this.bindFullBody(context, source);
    }

    protected ArgumentBinder.BindingResult<T> bindBodyPart(ArgumentConversionContext<T> context, HttpRequest<?> source, String bodyComponent) {
        return this.bindFullBodyConvertibleValues(source).flatMap(cv -> this.doBind(context, (ConvertibleValues<?>)cv, bodyComponent));
    }

    protected ArgumentBinder.BindingResult<ConvertibleValues<?>> bindFullBodyConvertibleValues(HttpRequest<?> source) {
        Optional<ConvertibleValues> convertibleValuesBody = source.getBody(ConvertibleValues.class);
        return () -> convertibleValuesBody;
    }

    public ArgumentBinder.BindingResult<T> bindFullBody(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Optional body = source.getBody();
        return body.isPresent() ? this.doConvert(body.get(), context) : ArgumentBinder.BindingResult.empty();
    }
}

