/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.ObjectUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
final class BeanIntrospectionMap<T>
implements BeanMap<T> {
    private final BeanIntrospection<T> beanIntrospection;
    private final T bean;

    BeanIntrospectionMap(BeanIntrospection<T> beanIntrospection, T bean) {
        this.beanIntrospection = beanIntrospection;
        this.bean = bean;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanIntrospectionMap that = (BeanIntrospectionMap)o;
        return this.beanIntrospection.equals(that.beanIntrospection) && this.bean.equals(that.bean);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(this.beanIntrospection, this.bean);
    }

    @Override
    @NonNull
    public Class<T> getBeanType() {
        return this.beanIntrospection.getBeanType();
    }

    @Override
    public int size() {
        return this.beanIntrospection.getPropertyNames().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.beanIntrospection.getProperty(key.toString()).isPresent();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.beanIntrospection.getProperty(key.toString()).map(bp -> bp.get(this.bean)).orElse(null);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            return null;
        }
        this.beanIntrospection.getProperty(key).ifPresent(bp -> {
            Class propertyType = bp.getType();
            if (value != null && !propertyType.isInstance(value)) {
                Optional<Object> converted = ConversionService.SHARED.convert(value, propertyType);
                converted.ifPresent(o -> bp.set(this.bean, o));
            } else {
                bp.set(this.bean, value);
            }
        });
        return null;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("Removal is not supported");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Removal is not supported");
    }

    @Override
    public Set<String> keySet() {
        return CollectionUtils.setOf(this.beanIntrospection.getPropertyNames());
    }

    @Override
    public Collection<Object> values() {
        return this.keySet().stream().map(this::get).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.keySet().stream().map(key -> new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return BeanIntrospectionMap.this.get(key);
            }

            @Override
            public Object setValue(Object value) {
                return BeanIntrospectionMap.this.put(key, value);
            }
        }).collect(Collectors.toSet());
    }
}

