/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnvironmentPropertySource
extends MapPropertySource {
    public static final int POSITION = -200;
    public static final String NAME = "env";

    public EnvironmentPropertySource() {
        super(NAME, EnvironmentPropertySource.getEnv(null, null));
    }

    public EnvironmentPropertySource(@Nullable List<String> includes, @Nullable List<String> excludes) {
        super(NAME, EnvironmentPropertySource.getEnv(includes, excludes));
    }

    @Override
    public int getOrder() {
        return -200;
    }

    @Override
    public PropertySource.PropertyConvention getConvention() {
        return PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE;
    }

    static Map getEnv(@Nullable List<String> includes, @Nullable List<String> excludes) {
        return EnvironmentPropertySource.getEnv(CachedEnvironment.getenv(), includes, excludes);
    }

    static Map getEnv(Map<String, String> env, @Nullable List<String> includes, @Nullable List<String> excludes) {
        if (includes != null || excludes != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String envVar = entry.getKey();
                if (excludes != null && excludes.contains(envVar) || includes != null && !includes.contains(envVar)) continue;
                result.put(envVar, entry.getValue());
            }
            return result;
        }
        return env;
    }
}

