/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.converters;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.reflect.ClassUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Prototype
@Internal
public class ContextConverterRegistrar
implements TypeConverterRegistrar {
    private final BeanContext beanContext;
    private final Map<String, Class<?>> classCache = new ConcurrentHashMap(10);

    ContextConverterRegistrar(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(String[].class, Class[].class, (object, targetType, context) -> {
            Class[] classes = (Class[])Arrays.stream(object).map(str -> conversionService.convert(str, Class.class)).filter(Optional::isPresent).map(Optional::get).toArray(Class[]::new);
            return Optional.of(classes);
        });
        conversionService.addConverter(String.class, Class.class, (object, targetType, context) -> {
            Class result = this.classCache.computeIfAbsent((String)object, s -> ClassUtils.forName(s, this.beanContext.getClassLoader()).orElse(MissingClass.class));
            if (result == MissingClass.class) {
                return Optional.empty();
            }
            return Optional.of(result);
        });
    }

    private final class MissingClass {
        private MissingClass() {
        }
    }
}

