/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@Singleton
class OptionalValuesSerializer<V>
implements CustomizableSerializer<OptionalValues<V>> {
    OptionalValuesSerializer() {
    }

    public Serializer<OptionalValues<V>> createSpecific(Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Cannot serialize raw OptionalValues");
        }
        Object generic = generics[0];
        final Serializer valueSerializer = context.findSerializer((Argument)generic).createSpecific(context, (Argument)generic);
        return new Serializer<OptionalValues<V>>(){
            final /* synthetic */ Argument val$generic;
            {
                this.val$generic = argument;
            }

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type, OptionalValues<V> value) throws IOException {
                Objects.requireNonNull(value, "Value cannot be null");
                Encoder objectEncoder = encoder.encodeObject(type);
                for (CharSequence key : value) {
                    Optional opt = value.get(key);
                    if (!opt.isPresent()) continue;
                    objectEncoder.encodeKey(key.toString());
                    valueSerializer.serialize(encoder, context, this.val$generic, opt.get());
                }
                objectEncoder.finishStructure();
            }
        };
    }

    public boolean isEmpty(Serializer.EncoderContext context, OptionalValues<V> value) {
        return value.isEmpty();
    }
}

