/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;
import java.util.Collection;

final class CustomizedIterableSerializer<T>
implements Serializer<Iterable<T>> {
    private final Argument<T> generic;
    private final Serializer<? super T> componentSerializer;

    CustomizedIterableSerializer(Argument<T> generic, Serializer<? super T> componentSerializer) {
        this.generic = generic;
        this.componentSerializer = componentSerializer;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Iterable<T>> type, Iterable<T> value) throws IOException {
        try (Encoder array = encoder.encodeArray(type);){
            for (T t : value) {
                if (t == null) {
                    encoder.encodeNull();
                    continue;
                }
                this.componentSerializer.serialize(array, context, this.generic, t);
            }
        }
    }

    public boolean isEmpty(Serializer.EncoderContext context, Iterable<T> value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        return !value.iterator().hasNext();
    }

    public boolean isAbsent(Serializer.EncoderContext context, Iterable<T> value) {
        return value == null;
    }
}

