/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalQuery;

@Singleton
public class YearSerde
implements TemporalSerde<Year> {
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Year> type, Year value) throws IOException {
        encoder.encodeInt(value.getValue());
    }

    @Override
    public TemporalQuery<Year> query() {
        return temporal -> Year.of(temporal.get(ChronoField.YEAR));
    }

    public Year deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Year> type) throws IOException {
        return Year.of(decoder.decodeInt());
    }
}

