/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serdes.EnumCreatorDeserializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;

@Singleton
final class EnumSerde<E extends Enum<E>>
implements Serde<E> {
    private final SerdeIntrospections introspections;

    EnumSerde(SerdeIntrospections introspections) {
        this.introspections = introspections;
    }

    @NonNull
    public E deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super E> type) throws IOException {
        Class t = type.getType();
        String s = decoder.decodeString();
        try {
            return (E)Enum.valueOf(t, s);
        }
        catch (IllegalArgumentException e) {
            try {
                return (E)Enum.valueOf(t, s.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                throw e;
            }
        }
    }

    @NonNull
    public Deserializer<E> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) {
        try {
            BeanIntrospection deserializableIntrospection = this.introspections.getDeserializableIntrospection(type);
            Argument[] constructorArguments = deserializableIntrospection.getConstructorArguments();
            if (constructorArguments.length != 1) {
                throw new SerdeException("Creator method for Enums must accept exactly 1 argument");
            }
            Argument argumentType = constructorArguments[0];
            Deserializer argumentDeserializer = context.findDeserializer(argumentType);
            return new EnumCreatorDeserializer((Argument<Object>)argumentType, (Deserializer<Object>)argumentDeserializer, deserializableIntrospection, argumentType.isNullable());
        }
        catch (IntrospectionException | SerdeException e) {
            return this;
        }
    }

    @NonNull
    public Serializer<E> createSpecific(@NonNull Serializer.EncoderContext context, @NonNull Argument<? extends E> type) throws SerdeException {
        try {
            BeanIntrospection si = this.introspections.getSerializableIntrospection(type);
            Collection beanMethods = si.getBeanMethods();
            for (BeanMethod beanMethod : beanMethods) {
                if (!beanMethod.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerValue.class)) continue;
                Argument valueType = beanMethod.getReturnType().asArgument();
                Serializer valueSerializer = context.findSerializer(valueType);
                return (encoder, subContext, subType, value) -> {
                    Object result = beanMethod.invoke(value, new Object[0]);
                    if (result == null) {
                        encoder.encodeNull();
                    } else {
                        valueSerializer.serialize(encoder, subContext, subType, result);
                    }
                };
            }
            return this;
        }
        catch (IntrospectionException e) {
            return this;
        }
    }

    public void serialize(Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends E> type, E value) throws IOException {
        encoder.encodeString(((Enum)value).name());
    }
}

