/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import java.io.IOException;
import java.util.Collection;

abstract class CollectionDeserializer<E, C extends Collection<E>>
implements Deserializer<C> {
    private final Deserializer<? extends E> valueDeser;
    private final Argument<E> collectionItemArgument;

    CollectionDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        this.valueDeser = valueDeser;
        this.collectionItemArgument = collectionItemArgument;
    }

    protected final void doDeserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Collection<E> collection) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        while (arrayDecoder.hasNextArrayValue()) {
            Object deserialize = this.valueDeser.deserializeNullable(arrayDecoder, decoderContext, this.collectionItemArgument);
            collection.add(deserialize);
        }
        arrayDecoder.finishStructure();
    }
}

