/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import java.io.IOException;

final class SimpleBuilderDeserializer
implements Deserializer<Object> {
    private final PropertiesBag<Object> builderParameters;
    private final BeanIntrospection<Object> introspection;
    @Nullable
    private final SerdeDeserializationPreInstantiateCallback preInstantiateCallback;
    private final boolean ignoreUnknown;
    private final boolean strictNullable;

    SimpleBuilderDeserializer(PropertiesBag<Object> builderParameters, BeanIntrospection<Object> introspection, SerdeDeserializationPreInstantiateCallback preInstantiateCallback, boolean ignoreUnknown, boolean strictNullable) {
        this.builderParameters = builderParameters;
        this.introspection = introspection;
        this.preInstantiateCallback = preInstantiateCallback;
        this.ignoreUnknown = ignoreUnknown;
        this.strictNullable = strictNullable;
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type) throws IOException {
        BeanIntrospection.Builder builder = this.introspection.builder();
        Decoder objectDecoder = decoder.decodeObject(type);
        if (this.builderParameters != null) {
            String prop;
            PropertiesBag.Consumer propertiesConsumer = this.builderParameters.newConsumer();
            boolean allConsumed = false;
            while (!allConsumed && (prop = objectDecoder.decodeKey()) != null) {
                DeserBean.DerProperty consumedProperty = propertiesConsumer.consume(prop);
                if (consumedProperty != null) {
                    consumedProperty.deserializeAndCallBuilder(objectDecoder, context, builder);
                    allConsumed = propertiesConsumer.isAllConsumed();
                    continue;
                }
                if (this.ignoreUnknown) {
                    objectDecoder.skipValue();
                    continue;
                }
                throw this.unknownProperty(type, prop);
            }
        }
        if (this.ignoreUnknown) {
            objectDecoder.finishStructure(true);
        } else {
            String unknownProp = objectDecoder.decodeKey();
            if (unknownProp != null) {
                throw this.unknownProperty(type, unknownProp);
            }
            objectDecoder.finishStructure();
        }
        return builder.build();
    }

    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    private SerdeException unknownProperty(Argument<? super Object> beanType, String prop) {
        return new SerdeException("Unknown property [" + prop + "] encountered during deserialization of type: " + beanType);
    }
}

