/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.AbstractStreamDecoder;
import java.io.IOException;

@Internal
public abstract class AbstractDecoderPerStructureStreamDecoder
extends AbstractStreamDecoder {
    @Nullable
    AbstractDecoderPerStructureStreamDecoder parent;
    private AbstractStreamDecoder child = null;

    protected AbstractDecoderPerStructureStreamDecoder(@NonNull AbstractDecoderPerStructureStreamDecoder parent, @NonNull LimitingStream.RemainingLimits remainingLimits) {
        this(remainingLimits);
        this.parent = parent;
    }

    protected AbstractDecoderPerStructureStreamDecoder(@NonNull LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
    }

    protected abstract AbstractStreamDecoder createChildDecoder() throws SerdeException;

    AbstractStreamDecoder childDecoder() throws SerdeException {
        return this.createChildDecoder();
    }

    @Override
    protected void preDecodeValue(AbstractStreamDecoder.TokenType currentToken) {
        super.preDecodeValue(currentToken);
        this.checkChild();
    }

    @Override
    public void finishStructure(boolean consumeLeftElements) throws IOException {
        this.checkChild();
        super.finishStructure(consumeLeftElements);
        if (this.parent != null) {
            this.transferControlToParent();
        }
    }

    @Override
    public boolean hasNextArrayValue() {
        this.checkChild();
        return super.hasNextArrayValue();
    }

    @Override
    public final String decodeKey() throws IOException {
        this.checkChild();
        return super.decodeKey();
    }

    @Override
    protected AbstractStreamDecoder decodeArray0(AbstractStreamDecoder.TokenType currentToken) throws IOException {
        super.decodeArray0(currentToken);
        this.decreaseDepth();
        this.child = this.childDecoder();
        return this.child;
    }

    @Override
    protected AbstractStreamDecoder decodeObject0(AbstractStreamDecoder.TokenType currentToken) throws IOException {
        super.decodeObject0(currentToken);
        this.decreaseDepth();
        this.child = this.childDecoder();
        return this.child;
    }

    private void checkChild() {
        if (this.child != null) {
            throw new IllegalStateException("There is still an unfinished child parser");
        }
        if (this.parent != null && this.parent.child != this) {
            throw new IllegalStateException("This child parser has already completed");
        }
    }

    void transferControlToParent() throws IOException {
        this.parent.child = null;
        this.parent.backFromChild(this);
    }

    protected void backFromChild(AbstractStreamDecoder child) throws IOException {
        this.nextToken();
    }
}

