/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Locale;

@Internal
final class LocaleSerde
implements SerdeRegistrar<Locale> {
    LocaleSerde() {
    }

    @Override
    public Argument<Locale> getType() {
        return Argument.of(Locale.class);
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Locale> type, Locale value) throws IOException {
        encoder.encodeString(value.toLanguageTag());
    }

    public Locale deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Locale> type) throws IOException {
        return StringUtils.parseLocale((String)decoder.decodeString());
    }

    public Locale deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Locale> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }
}

