/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class CharSerde
implements SerdeRegistrar<Character> {
    CharSerde() {
    }

    public Character deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Character> type) throws IOException {
        return Character.valueOf(decoder.decodeChar());
    }

    public Character deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Character> type) throws IOException {
        return decoder.decodeCharNullable();
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Character> type, Character value) throws IOException {
        encoder.encodeChar(value.charValue());
    }

    @Override
    public Argument<Character> getType() {
        return Argument.of(Character.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.CHAR);
    }

    @Nullable
    public Character getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Character> type) {
        return type.isPrimitive() ? Character.valueOf('\u0000') : null;
    }
}

