/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class CharArraySerde
implements SerdeRegistrar<char[]> {
    CharArraySerde() {
    }

    public char[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super char[]> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        char[] buffer = new char[100];
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            if (buffer.length == index) {
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            if (!arrayDecoder.decodeNull()) {
                buffer[index] = arrayDecoder.decodeChar();
            }
            ++index;
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }

    public char[] deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super char[]> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends char[]> type, char[] value) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (char i : value) {
            arrayEncoder.encodeChar(i);
        }
        arrayEncoder.finishStructure();
    }

    public boolean isEmpty(Serializer.EncoderContext context, char[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public Argument<char[]> getType() {
        return Argument.of(char[].class);
    }
}

