/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.DelegatingDecoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.support.util.JsonNodeDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Internal
final class DemuxingObjectDecoder
extends DelegatingDecoder {
    private final DemuxerState state;
    private final boolean consumeValues;
    private int nextKeyIndex;

    private DemuxingObjectDecoder(DemuxerState state, boolean consumeValues) {
        this.state = state;
        this.consumeValues = consumeValues;
        ++state.outputCount;
    }

    public static PrimedDecoder prime(Decoder decoder) {
        return new PrimedDecoder(decoder);
    }

    @Nullable
    public String decodeKey() throws IOException {
        DemuxerState.Entry entry;
        do {
            if ((entry = this.state.getEntry(this.nextKeyIndex++)) != null) continue;
            return null;
        } while (entry.consumed);
        return entry.key;
    }

    @NonNull
    private DemuxerState.Entry entryForValue() throws IOException {
        if (this.nextKeyIndex == 0) {
            throw new IllegalStateException("Must call decodeKey first");
        }
        DemuxerState.Entry entry = this.state.getEntry(this.nextKeyIndex - 1);
        if (entry == null) {
            throw new IllegalStateException("End of object, decodeKey should have returned null");
        }
        return entry;
    }

    protected Decoder delegate() throws IOException {
        DemuxerState.Entry entry = this.entryForValue();
        return entry.peekOrConsume(this.consumeValues);
    }

    public boolean decodeNull() throws IOException {
        DemuxerState.Entry entry = this.entryForValue();
        return entry.peekOrConsumeNull(this.consumeValues);
    }

    public void skipValue() throws IOException {
        this.entryForValue();
    }

    public void finishStructure() throws IOException {
        this.finishStructure(false);
    }

    public void finishStructure(boolean consumeLeftElements) throws IOException {
        if (!consumeLeftElements && this.nextKeyIndex <= this.state.buffer.size() && this.decodeKey() != null) {
            throw new IllegalStateException("Not all items consumed");
        }
        this.state.removeOutput();
    }

    public boolean hasNextArrayValue() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.finishStructure(true);
    }

    @NonNull
    public IOException createDeserializationException(@NonNull String message, @Nullable Object invalidValue) {
        return this.state.delegate.createDeserializationException(message, invalidValue);
    }

    private static class DemuxerState {
        private final Decoder delegate;
        private final List<Entry> buffer = new ArrayList<Entry>();
        private boolean hitEnd = false;
        private int outputCount = 0;

        DemuxerState(Decoder delegate) {
            this.delegate = delegate;
        }

        Entry getEntry(int i) throws IOException {
            String key;
            if (this.buffer.size() > i) {
                return this.buffer.get(i);
            }
            if (this.buffer.size() != i) {
                throw new IllegalArgumentException("Must access entries in sequence");
            }
            if (this.hitEnd) {
                return null;
            }
            if (!this.buffer.isEmpty()) {
                Entry lastEntry = this.buffer.get(this.buffer.size() - 1);
                if (!lastEntry.consumed && lastEntry.buffer == null) {
                    lastEntry.buffer = this.delegate.decodeBuffer();
                }
            }
            if ((key = this.delegate.decodeKey()) == null) {
                this.hitEnd = true;
                return null;
            }
            Entry entry = new Entry(key);
            this.buffer.add(entry);
            return entry;
        }

        void removeOutput() throws IOException {
            if (--this.outputCount == 0) {
                this.delegate.finishStructure(true);
            }
        }

        private class Entry {
            final String key;
            Decoder buffer = null;
            boolean consumed = false;

            Entry(String key) {
                this.key = key;
            }

            Decoder peekOrConsume(boolean consume) throws IOException {
                Decoder decoder = this.provideDecoder(consume);
                if (consume) {
                    this.consumed = true;
                }
                return decoder;
            }

            boolean peekOrConsumeNull(boolean consume) throws IOException {
                Decoder decoder = this.provideDecoder(consume);
                boolean isNull = decoder.decodeNull();
                if (isNull && consume) {
                    this.consumed = true;
                }
                return isNull;
            }

            private Decoder provideDecoder(boolean willConsume) throws IOException {
                if (this.consumed) {
                    throw new IllegalStateException("Entry already consumed");
                }
                Decoder decoder = this.buffer != null ? this.buffer : DemuxerState.this.delegate;
                if (willConsume) {
                    return decoder;
                }
                JsonNode node = decoder.decodeNode();
                this.buffer = JsonNodeDecoder.create(node, LimitingStream.DEFAULT_LIMITS);
                return JsonNodeDecoder.create(node, LimitingStream.DEFAULT_LIMITS);
            }
        }
    }

    static final class PrimedDecoder
    extends DelegatingDecoder {
        private final Decoder delegate;
        @Nullable
        private DemuxerState state;

        private PrimedDecoder(Decoder delegate) {
            this.delegate = delegate;
        }

        @NonNull
        public DemuxingObjectDecoder decodeObject() throws IOException {
            if (this.state == null) {
                this.state = new DemuxerState(this.delegate.decodeObject());
                ++this.state.outputCount;
            }
            return new DemuxingObjectDecoder(this.state, true);
        }

        @NonNull
        public DemuxingObjectDecoder decodeObject(@NonNull Argument<?> type) throws IOException {
            if (this.state == null) {
                this.state = new DemuxerState(this.delegate.decodeObject(type));
                ++this.state.outputCount;
            }
            return new DemuxingObjectDecoder(this.state, true);
        }

        @NonNull
        public DemuxingObjectDecoder decodeObjectNonConsuming(@NonNull Argument<?> type) throws IOException {
            if (this.state == null) {
                this.state = new DemuxerState(this.delegate.decodeObject(type));
                ++this.state.outputCount;
            }
            return new DemuxingObjectDecoder(this.state, false);
        }

        public boolean decodeNull() throws IOException {
            return false;
        }

        protected Decoder delegate() throws IOException {
            throw new UnsupportedOperationException();
        }

        @NonNull
        public IOException createDeserializationException(@NonNull String message, @Nullable Object invalidValue) {
            return this.delegate.createDeserializationException(message, invalidValue);
        }

        public void close() throws IOException {
            if (this.state == null) {
                this.state = new DemuxerState(this.delegate.decodeObject());
                ++this.state.outputCount;
            }
            this.state.removeOutput();
        }
    }
}

