/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.processor.jackson.ValidatingAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JsonFormatMapper
extends ValidatingAnnotationMapper {
    private static final Set<String> MEMBER_NAMES = CollectionUtils.setOf((Object[])new String[]{"pattern", "locale", "timezone", "lenient"});

    @Override
    protected List<AnnotationValue<?>> mapValid(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.class);
        for (String memberName : MEMBER_NAMES) {
            annotation.stringValue(memberName).ifPresent(p -> builder.member(memberName, p));
        }
        return Collections.singletonList(builder.build());
    }

    @Override
    protected Set<String> getSupportedMemberNames() {
        return MEMBER_NAMES;
    }

    public String getName() {
        return "com.fasterxml.jackson.annotation.JsonFormat";
    }
}

