/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.AbstractDecoderPerStructureStreamDecoder;
import io.micronaut.serde.support.AbstractStreamDecoder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Internal
public final class BsonReaderDecoder
extends AbstractDecoderPerStructureStreamDecoder {
    private final BsonReader bsonReader;
    private final Deque<Context> contextStack;
    private BsonType currentBsonType;
    private AbstractStreamDecoder.TokenType currentToken;

    public BsonReaderDecoder(BsonReader bsonReader, @NonNull LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.bsonReader = bsonReader;
        this.contextStack = new ArrayDeque<Context>();
        BsonType currentBsonType = bsonReader.getCurrentBsonType();
        if (currentBsonType == null) {
            this.contextStack.add(Context.TOP);
            this.nextToken();
        } else if (currentBsonType == BsonType.DOCUMENT) {
            this.contextStack.push(Context.TOP);
            this.currentToken = AbstractStreamDecoder.TokenType.START_OBJECT;
            this.currentBsonType = BsonType.DOCUMENT;
        }
    }

    private BsonReaderDecoder(BsonReaderDecoder parent, @NonNull LimitingStream.RemainingLimits remainingLimits) {
        super((AbstractDecoderPerStructureStreamDecoder)parent, remainingLimits);
        this.bsonReader = parent.bsonReader;
        this.contextStack = parent.contextStack;
        this.currentBsonType = parent.currentBsonType;
        this.currentToken = parent.currentToken;
    }

    protected void backFromChild(AbstractStreamDecoder child) throws IOException {
        this.currentBsonType = ((BsonReaderDecoder)child).currentBsonType;
        this.currentToken = ((BsonReaderDecoder)child).currentToken;
        super.backFromChild(child);
    }

    protected void nextToken() {
        Context ctx;
        if (this.currentToken != null) {
            switch (this.currentToken) {
                case START_ARRAY: {
                    this.contextStack.push(Context.ARRAY);
                    this.bsonReader.readStartArray();
                    break;
                }
                case START_OBJECT: {
                    this.contextStack.push(Context.DOCUMENT);
                    this.bsonReader.readStartDocument();
                    break;
                }
                case END_ARRAY: {
                    this.contextStack.pop();
                    this.bsonReader.readEndArray();
                    break;
                }
                case END_OBJECT: {
                    this.contextStack.pop();
                    this.bsonReader.readEndDocument();
                    break;
                }
                case NULL: {
                    this.bsonReader.readNull();
                    break;
                }
            }
        }
        if ((ctx = this.contextStack.peek()) == Context.DOCUMENT) {
            if (this.currentToken == AbstractStreamDecoder.TokenType.KEY) {
                this.currentToken = BsonReaderDecoder.toToken(this.currentBsonType, ctx);
            } else {
                this.currentBsonType = this.bsonReader.readBsonType();
                this.currentToken = this.currentBsonType == BsonType.END_OF_DOCUMENT ? AbstractStreamDecoder.TokenType.END_OBJECT : AbstractStreamDecoder.TokenType.KEY;
            }
        } else if (ctx != Context.TOP || this.currentBsonType != BsonType.END_OF_DOCUMENT) {
            this.currentBsonType = this.bsonReader.readBsonType();
            this.currentToken = BsonReaderDecoder.toToken(this.currentBsonType, ctx);
        }
    }

    private static AbstractStreamDecoder.TokenType toToken(BsonType bsonType, Context ctx) {
        switch (bsonType) {
            case ARRAY: {
                return AbstractStreamDecoder.TokenType.START_ARRAY;
            }
            case DOCUMENT: {
                return AbstractStreamDecoder.TokenType.START_OBJECT;
            }
            case END_OF_DOCUMENT: {
                if (ctx == Context.ARRAY) {
                    return AbstractStreamDecoder.TokenType.END_ARRAY;
                }
                if (ctx == Context.DOCUMENT) {
                    return AbstractStreamDecoder.TokenType.END_OBJECT;
                }
                return null;
            }
            case DOUBLE: 
            case INT32: 
            case INT64: 
            case DECIMAL128: {
                return AbstractStreamDecoder.TokenType.NUMBER;
            }
            case STRING: {
                return AbstractStreamDecoder.TokenType.STRING;
            }
            case BOOLEAN: {
                return AbstractStreamDecoder.TokenType.BOOLEAN;
            }
            case NULL: {
                return AbstractStreamDecoder.TokenType.NULL;
            }
        }
        return AbstractStreamDecoder.TokenType.OTHER;
    }

    protected String getCurrentKey() {
        return this.bsonReader.readName();
    }

    protected String coerceScalarToString(AbstractStreamDecoder.TokenType currentToken) throws IOException {
        switch (this.currentBsonType) {
            case DOUBLE: {
                return String.valueOf(this.bsonReader.readDouble());
            }
            case STRING: {
                return this.bsonReader.readString();
            }
            case OBJECT_ID: {
                return this.bsonReader.readObjectId().toHexString();
            }
            case BOOLEAN: {
                return String.valueOf(this.bsonReader.readBoolean());
            }
            case DATE_TIME: {
                return String.valueOf(this.bsonReader.readDateTime());
            }
            case REGULAR_EXPRESSION: {
                return this.bsonReader.readRegularExpression().toString();
            }
            case JAVASCRIPT: {
                return this.bsonReader.readJavaScript();
            }
            case SYMBOL: {
                return this.bsonReader.readSymbol();
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return this.bsonReader.readJavaScriptWithScope();
            }
            case INT32: {
                return String.valueOf(this.bsonReader.readInt32());
            }
            case TIMESTAMP: {
                return this.bsonReader.readTimestamp().toString();
            }
            case INT64: {
                return String.valueOf(this.bsonReader.readInt64());
            }
            case DECIMAL128: {
                return this.bsonReader.readDecimal128().toString();
            }
            case BINARY: {
                return new String(this.bsonReader.readBinaryData().getData(), StandardCharsets.UTF_8);
            }
            case DB_POINTER: {
                return this.bsonReader.readDBPointer().toString();
            }
        }
        throw new SerdeException("Can't decode " + this.currentBsonType + " as string");
    }

    protected AbstractStreamDecoder createChildDecoder() throws SerdeException {
        return new BsonReaderDecoder(this, this.childLimits());
    }

    protected String getString() {
        return this.bsonReader.readString();
    }

    protected boolean getBoolean() {
        return this.bsonReader.readBoolean();
    }

    protected long getLong() {
        switch (this.currentBsonType) {
            case INT32: {
                return this.bsonReader.readInt32();
            }
            case INT64: {
                return this.bsonReader.readInt64();
            }
            case DOUBLE: {
                return (long)this.bsonReader.readDouble();
            }
            case DECIMAL128: {
                return this.bsonReader.readDecimal128().longValue();
            }
        }
        throw new IllegalStateException("Not in number state");
    }

    protected double getDouble() {
        switch (this.currentBsonType) {
            case INT32: {
                return this.bsonReader.readInt32();
            }
            case INT64: {
                return this.bsonReader.readInt64();
            }
            case DOUBLE: {
                return this.bsonReader.readDouble();
            }
            case DECIMAL128: {
                return this.bsonReader.readDecimal128().doubleValue();
            }
        }
        throw new IllegalStateException("Not in number state");
    }

    protected BigInteger getBigInteger() {
        switch (this.currentBsonType) {
            case INT32: {
                return BigInteger.valueOf(this.bsonReader.readInt32());
            }
            case INT64: {
                return BigInteger.valueOf(this.bsonReader.readInt64());
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.bsonReader.readDouble()).toBigInteger();
            }
            case DECIMAL128: {
                return this.bsonReader.readDecimal128().bigDecimalValue().toBigInteger();
            }
        }
        throw new IllegalStateException("Not in number state");
    }

    protected BigDecimal getBigDecimal() {
        switch (this.currentBsonType) {
            case INT32: {
                return BigDecimal.valueOf(this.bsonReader.readInt32());
            }
            case INT64: {
                return BigDecimal.valueOf(this.bsonReader.readInt64());
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.bsonReader.readDouble());
            }
            case DECIMAL128: {
                return this.bsonReader.readDecimal128().bigDecimalValue();
            }
        }
        throw new IllegalStateException("Not in number state");
    }

    protected Number getBestNumber() {
        switch (this.currentBsonType) {
            case INT32: {
                return this.bsonReader.readInt32();
            }
            case INT64: {
                return this.bsonReader.readInt64();
            }
            case DOUBLE: {
                return this.bsonReader.readDouble();
            }
            case DECIMAL128: {
                return this.bsonReader.readDecimal128();
            }
        }
        throw new IllegalStateException("Not in number state");
    }

    public byte @NonNull [] decodeBinary() throws IOException {
        if (this.currentBsonType == BsonType.BINARY) {
            return (byte[])this.decodeCustom(parser -> ((BsonReaderDecoder)parser).bsonReader.readBinaryData().getData());
        }
        return super.decodeBinary();
    }

    protected void skipChildren() {
        this.bsonReader.skipValue();
        this.currentToken = null;
    }

    protected AbstractStreamDecoder.TokenType currentToken() {
        return this.currentToken;
    }

    public IOException createDeserializationException(String message, Object invalidValue) {
        return new SerdeException(message + " \n at ");
    }

    private Decimal128 getDecimal128() {
        switch (this.currentBsonType) {
            case INT32: {
                return new Decimal128((long)this.bsonReader.readInt32());
            }
            case INT64: {
                return new Decimal128(this.bsonReader.readInt64());
            }
            case DOUBLE: {
                return new Decimal128(BigDecimal.valueOf(this.bsonReader.readDouble()));
            }
            case DECIMAL128: {
                return this.bsonReader.readDecimal128();
            }
        }
        throw new IllegalStateException("Not in number state");
    }

    public Decimal128 decodeDecimal128() throws IOException {
        return (Decimal128)this.decodeNumber(this.currentToken(), decoder -> ((BsonReaderDecoder)decoder).getDecimal128(), Decimal128::parse, Decimal128.POSITIVE_ZERO, new Decimal128(1L));
    }

    public ObjectId decodeObjectId() throws IOException {
        if (this.currentBsonType != BsonType.OBJECT_ID) {
            throw this.createDeserializationException("Cannot decode ObjectId from: " + this.currentBsonType, this.decodeArbitrary());
        }
        return (ObjectId)this.decodeCustom(parser -> ((BsonReaderDecoder)parser).bsonReader.readObjectId());
    }

    public <T> T decodeCustom(org.bson.codecs.Decoder<T> decoder, DecoderContext context) throws IOException {
        this.currentToken = null;
        this.currentBsonType = null;
        Object result = this.decodeCustom(p -> decoder.decode(this.bsonReader, context), false);
        Context ctx = this.contextStack.peek();
        if (ctx == Context.TOP) {
            return (T)result;
        }
        this.nextToken();
        return (T)result;
    }

    private byte[] copyValueToDocument() {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try (BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer);){
            writer.writeStartDocument();
            writer.writeName("");
            BsonReaderDecoder.transfer(this.bsonReader, (BsonWriter)writer, this.currentBsonType);
            writer.writeEndDocument();
        }
        this.currentToken = null;
        this.currentBsonType = null;
        return buffer.getInternalBuffer();
    }

    public Decoder decodeBuffer() throws IOException {
        byte[] documentBytes = (byte[])this.decodeCustom(p -> ((BsonReaderDecoder)p).copyValueToDocument());
        BsonReaderDecoder topDecoder = new BsonReaderDecoder((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(documentBytes)), this.ourLimits());
        Decoder objectDecoder = topDecoder.decodeObject();
        objectDecoder.decodeKey();
        return objectDecoder;
    }

    private static void transfer(BsonReader src, BsonWriter dest, BsonType type) {
        switch (type) {
            case DOUBLE: {
                dest.writeDouble(src.readDouble());
                break;
            }
            case STRING: {
                dest.writeString(src.readString());
                break;
            }
            case DOCUMENT: {
                dest.pipe(src);
                break;
            }
            case ARRAY: {
                BsonType elementType;
                src.readStartArray();
                dest.writeStartArray();
                while ((elementType = src.readBsonType()) != BsonType.END_OF_DOCUMENT) {
                    BsonReaderDecoder.transfer(src, dest, elementType);
                }
                src.readEndArray();
                dest.writeEndArray();
                break;
            }
            case BINARY: {
                dest.writeBinaryData(src.readBinaryData());
                break;
            }
            case UNDEFINED: {
                src.readUndefined();
                dest.writeUndefined();
                break;
            }
            case OBJECT_ID: {
                dest.writeObjectId(src.readObjectId());
                break;
            }
            case BOOLEAN: {
                dest.writeBoolean(src.readBoolean());
                break;
            }
            case DATE_TIME: {
                dest.writeDateTime(src.readDateTime());
                break;
            }
            case NULL: {
                src.readNull();
                dest.writeNull();
                break;
            }
            case REGULAR_EXPRESSION: {
                dest.writeRegularExpression(src.readRegularExpression());
                break;
            }
            case DB_POINTER: {
                dest.writeDBPointer(src.readDBPointer());
                break;
            }
            case JAVASCRIPT: {
                dest.writeJavaScript(src.readJavaScript());
                break;
            }
            case SYMBOL: {
                dest.writeSymbol(src.readSymbol());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                dest.writeJavaScriptWithScope(src.readJavaScriptWithScope());
                break;
            }
            case INT32: {
                dest.writeInt32(src.readInt32());
                break;
            }
            case TIMESTAMP: {
                dest.writeTimestamp(src.readTimestamp());
                break;
            }
            case INT64: {
                dest.writeInt64(src.readInt64());
                break;
            }
            case DECIMAL128: {
                dest.writeDecimal128(src.readDecimal128());
                break;
            }
            case MIN_KEY: {
                src.readMinKey();
                dest.writeMinKey();
                break;
            }
            case MAX_KEY: {
                src.readMaxKey();
                dest.writeMaxKey();
                break;
            }
            default: {
                throw new IllegalStateException("Can't transfer bson token: " + type);
            }
        }
    }

    private static enum Context {
        ARRAY,
        DOCUMENT,
        TOP;

    }
}

