/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.web.router.FilterRoute;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

class DefaultFilterRoute
implements FilterRoute {
    private final List<String> patterns = new ArrayList<String>(1);
    private final Supplier<GenericHttpFilter> filterSupplier;
    private final AnnotationMetadataResolver annotationMetadataResolver;
    private Set<HttpMethod> httpMethods;
    private FilterPatternStyle patternStyle;
    private volatile GenericHttpFilter filter;
    private AnnotationMetadata annotationMetadata;

    DefaultFilterRoute(Supplier<GenericHttpFilter> filter, AnnotationMetadataResolver annotationMetadataResolver) {
        Objects.requireNonNull(filter, "HttpFilter argument is required");
        this.filterSupplier = filter;
        this.annotationMetadataResolver = annotationMetadataResolver;
    }

    DefaultFilterRoute(String pattern, Supplier<GenericHttpFilter> filter, AnnotationMetadataResolver annotationMetadataResolver) {
        this(filter, annotationMetadataResolver);
        Objects.requireNonNull(pattern, "Pattern argument is required");
        this.patterns.add(pattern);
    }

    DefaultFilterRoute(String pattern, Supplier<GenericHttpFilter> filter) {
        this(pattern, filter, AnnotationMetadataResolver.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        AnnotationMetadata annotationMetadata = this.annotationMetadata;
        if (annotationMetadata == null) {
            DefaultFilterRoute defaultFilterRoute = this;
            synchronized (defaultFilterRoute) {
                annotationMetadata = this.annotationMetadata;
                if (annotationMetadata == null) {
                    this.annotationMetadata = annotationMetadata = this.annotationMetadataResolver.resolveMetadata((Object)this.getFilter());
                }
            }
        }
        return annotationMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericHttpFilter getFilter() {
        GenericHttpFilter filter = this.filter;
        if (filter == null) {
            DefaultFilterRoute defaultFilterRoute = this;
            synchronized (defaultFilterRoute) {
                filter = this.filter;
                if (filter == null) {
                    this.filter = filter = this.filterSupplier.get();
                }
            }
        }
        return filter;
    }

    @NonNull
    public Set<HttpMethod> getFilterMethods() {
        return this.httpMethods;
    }

    @NonNull
    public String[] getPatterns() {
        return this.patterns.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    public FilterPatternStyle getPatternStyle() {
        return this.patternStyle != null ? this.patternStyle : FilterPatternStyle.defaultStyle();
    }

    @Override
    public Optional<GenericHttpFilter> match(HttpMethod method, URI uri) {
        return this.match(method, uri.getPath());
    }

    @Override
    public Optional<GenericHttpFilter> match(HttpMethod method, String path) {
        if (this.httpMethods != null && !this.httpMethods.contains(method)) {
            return Optional.empty();
        }
        PathMatcher matcher = this.getPatternStyle().getPathMatcher();
        for (String pattern : this.patterns) {
            if (!matcher.matches(pattern, path)) continue;
            GenericHttpFilter filter = this.getFilter();
            if (!GenericHttpFilter.isEnabled((GenericHttpFilter)filter)) {
                return Optional.empty();
            }
            return Optional.of(filter);
        }
        return Optional.empty();
    }

    @Override
    public FilterRoute pattern(String pattern) {
        if (StringUtils.isNotEmpty((CharSequence)pattern)) {
            this.patterns.add(pattern);
        }
        return this;
    }

    @Override
    public FilterRoute methods(HttpMethod ... methods) {
        if (ArrayUtils.isNotEmpty((Object[])methods)) {
            if (this.httpMethods == null) {
                this.httpMethods = new HashSet<HttpMethod>();
            }
            this.httpMethods.addAll(Arrays.asList(methods));
        }
        return this;
    }

    @Override
    public FilterRoute patternStyle(FilterPatternStyle patternStyle) {
        this.patternStyle = patternStyle;
        return this;
    }
}

