/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.TrueCondition;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

@Internal
public record MatchesCustomCondition(AnnotationClassValue<?> customConditionClass) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        Object instance = this.customConditionClass.getInstance().orElse(null);
        if (instance instanceof Condition) {
            Condition condition = (Condition)instance;
            boolean conditionResult = condition.matches(context);
            if (!conditionResult) {
                context.fail("Custom condition [" + instance.getClass() + "] failed evaluation");
            }
            return conditionResult;
        }
        Class conditionClass = this.customConditionClass.getType().orElse(null);
        if (conditionClass == null || conditionClass == TrueCondition.class || !Condition.class.isAssignableFrom(conditionClass)) {
            return true;
        }
        Optional condition = InstantiationUtils.tryInstantiate((Class)conditionClass);
        if (condition.isPresent()) {
            boolean conditionResult = ((Condition)condition.get()).matches(context);
            if (!conditionResult) {
                context.fail("Custom condition [" + conditionClass + "] failed evaluation");
            }
            return conditionResult;
        }
        Optional constructor = ReflectionUtils.findConstructor((Class)conditionClass, (Class[])new Class[]{Object.class, Object.class});
        boolean conditionResult = constructor.flatMap(ctor -> InstantiationUtils.tryInstantiate((Constructor)ctor, (Object[])new Object[]{null, null})).flatMap(obj -> {
            Object result;
            Optional method = ReflectionUtils.findMethod(obj.getClass(), (String)"call", (Class[])new Class[]{ConditionContext.class});
            if (method.isPresent() && (result = ReflectionUtils.invokeMethod((Object)obj, (Method)((Method)method.get()), (Object[])new Object[]{context})) instanceof Boolean) {
                Boolean boolean1 = (Boolean)result;
                return Optional.of(boolean1);
            }
            return Optional.empty();
        }).orElse(false);
        if (!conditionResult) {
            context.fail("Custom condition [" + conditionClass + "] failed evaluation");
        }
        return conditionResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesCustomCondition that = (MatchesCustomCondition)o;
        return Objects.equals(this.customConditionClass, that.customConditionClass);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.customConditionClass);
    }

    @Override
    public String toString() {
        return "MatchesCustomCondition{customConditionClass=" + this.customConditionClass + "}";
    }
}

