/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class RepeatableAnnotationQualifier<T>
extends FilteringQualifier<T> {
    private final List<AnnotationValue<Annotation>> repeatableValues;
    private final String repeatableName;

    RepeatableAnnotationQualifier(AnnotationMetadata annotationMetadata, String repeatableName) {
        this.repeatableName = repeatableName;
        this.repeatableValues = annotationMetadata.findAnnotation(repeatableName).map(av -> av.getAnnotations("value")).orElse(Collections.emptyList());
        if (this.repeatableValues.isEmpty()) {
            throw new IllegalArgumentException("Repeatable qualifier [" + repeatableName + "] declared with no values");
        }
    }

    public String toString() {
        return Arrays.toString(this.repeatableValues.toArray());
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        AnnotationValue declared = candidate.getAnnotationMetadata().getAnnotation(this.repeatableName);
        if (declared != null) {
            List repeated = declared.getAnnotations("value");
            return repeated.containsAll(this.repeatableValues);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatableAnnotationQualifier that = (RepeatableAnnotationQualifier)o;
        return this.repeatableValues.equals(that.repeatableValues) && this.repeatableName.equals(that.repeatableName);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.repeatableValues, (Object)this.repeatableName);
    }
}

