/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.provider;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.provider.AbstractProviderDefinition;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
public final class BeanProviderDefinition
extends AbstractProviderDefinition<BeanProvider<Object>> {
    @Override
    public boolean isEnabled(BeanContext context, BeanResolutionContext resolutionContext) {
        return true;
    }

    @Override
    public Class<BeanProvider<Object>> getBeanType() {
        return BeanProvider.class;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    protected BeanProvider<Object> buildProvider(final @NonNull BeanResolutionContext resolutionContext, final @NonNull BeanContext context, final @NonNull Argument<Object> argument, final @Nullable Qualifier<Object> qualifier, boolean singleton) {
        return new BeanProvider<Object>(){
            private final DefaultBeanContext defaultBeanContext;
            private final Qualifier<Object> finalQualifier;
            {
                this.defaultBeanContext = (DefaultBeanContext)context;
                this.finalQualifier = qualifier instanceof AnyQualifier ? null : qualifier;
            }

            private Qualifier<Object> qualify(Qualifier<Object> qualifier2) {
                if (this.finalQualifier == null) {
                    return qualifier2;
                }
                if (qualifier2 == null) {
                    return this.finalQualifier;
                }
                return Qualifiers.byQualifiers(this.finalQualifier, qualifier2);
            }

            @Override
            public Object get() {
                return this.defaultBeanContext.getBean(resolutionContext.copy(), argument, this.finalQualifier);
            }

            @Override
            public Optional<Object> find(Qualifier<Object> qualifier2) {
                return this.defaultBeanContext.findBean(resolutionContext.copy(), argument, this.qualify(qualifier2));
            }

            @Override
            public BeanDefinition<Object> getDefinition() {
                return context.getBeanDefinition(argument, this.finalQualifier);
            }

            @Override
            public Object get(Qualifier<Object> qualifier2) {
                return this.defaultBeanContext.getBean(resolutionContext.copy(), argument, this.qualify(qualifier2));
            }

            @Override
            public boolean isUnique() {
                try {
                    return context.getBeanDefinitions(argument, this.finalQualifier).size() == 1;
                }
                catch (NoSuchBeanException e) {
                    return false;
                }
            }

            @Override
            public boolean isPresent() {
                return context.containsBean(argument, this.finalQualifier);
            }

            @Override
            @NonNull
            public Iterator<Object> iterator() {
                return this.defaultBeanContext.getBeansOfType(resolutionContext.copy(), argument, this.finalQualifier).iterator();
            }

            @Override
            public Stream<Object> stream() {
                return this.defaultBeanContext.streamOfType(resolutionContext.copy(), argument, this.finalQualifier);
            }
        };
    }

    @Override
    protected boolean isAllowEmptyProviders(BeanContext context) {
        return true;
    }
}

