/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.qualifiers.PrimaryQualifier;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

final class DefaultRuntimeBeanDefinition<T>
extends AbstractBeanContextConditional
implements RuntimeBeanDefinition<T> {
    private static final AtomicInteger REF_COUNT = new AtomicInteger(0);
    private static final String MSG_BEAN_TYPE_CANNOT_BE_NULL = "Bean type cannot be null";
    private final Argument<T> beanType;
    private final Supplier<T> supplier;
    private final AnnotationMetadata annotationMetadata;
    private final String beanName;
    private final Qualifier<T> qualifier;
    private final boolean isSingleton;
    private final Class<? extends Annotation> scope;
    private final Class<?>[] exposedTypes;
    private Map<Class<?>, List<Argument<?>>> typeArguments;

    DefaultRuntimeBeanDefinition(@NonNull Argument<T> beanType, @NonNull Supplier<T> supplier, @Nullable Qualifier<T> qualifier, @Nullable AnnotationMetadata annotationMetadata, boolean isSingleton, @Nullable Class<? extends Annotation> scope, Class<?>[] exposedTypes, Map<Class<?>, List<Argument<?>>> typeArguments) {
        Objects.requireNonNull(beanType, MSG_BEAN_TYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(supplier, "Bean supplier cannot be null");
        this.beanType = beanType;
        this.supplier = supplier;
        this.beanName = DefaultRuntimeBeanDefinition.generateBeanName(beanType.getType());
        this.qualifier = qualifier;
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : annotationMetadata;
        this.isSingleton = isSingleton;
        this.scope = scope;
        this.exposedTypes = exposedTypes;
        this.typeArguments = typeArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Argument<?>> getTypeArguments(Class<?> type) {
        Class<T> bt = this.getBeanType();
        if (type == bt) {
            return this.getTypeArguments();
        }
        if (type != null && type.isAssignableFrom(bt)) {
            List<Argument<?>> args;
            if (this.typeArguments != null && (args = this.typeArguments.get(type)) != null) {
                return args;
            }
            List<Argument<?>> list = RuntimeBeanDefinition.super.getTypeArguments(type);
            if (CollectionUtils.isNotEmpty(list)) {
                if (this.typeArguments == null) {
                    Argument<T> argument = this.beanType;
                    synchronized (argument) {
                        this.typeArguments = new LinkedHashMap(3);
                    }
                }
                this.typeArguments.put(type, list);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    @NonNull
    public Set<Class<?>> getExposedTypes() {
        return ArrayUtils.isNotEmpty((Object[])this.exposedTypes) ? CollectionUtils.setOf((Object[])this.exposedTypes) : RuntimeBeanDefinition.super.getExposedTypes();
    }

    @Override
    public Optional<Class<? extends Annotation>> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    public Optional<String> getScopeName() {
        return this.getScope().map(Class::getName);
    }

    @Override
    @NonNull
    public Argument<T> asArgument() {
        return this.beanType;
    }

    @Override
    public boolean isPrimary() {
        return this.qualifier == PrimaryQualifier.INSTANCE || RuntimeBeanDefinition.super.isPrimary();
    }

    @Override
    public Qualifier<T> getDeclaredQualifier() {
        return this.qualifier != null ? this.qualifier : RuntimeBeanDefinition.super.getDeclaredQualifier();
    }

    @Override
    public Qualifier<T> resolveDynamicQualifier() {
        return this.qualifier;
    }

    static String generateBeanName(@NonNull Class<?> beanType) {
        Objects.requireNonNull(beanType, MSG_BEAN_TYPE_CANNOT_BE_NULL);
        return beanType.getName() + "$DynamicDefinition" + REF_COUNT.incrementAndGet();
    }

    @Override
    public String getBeanDefinitionName() {
        return this.beanName;
    }

    @Override
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public BeanDefinition<T> load() {
        return this;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType.getType();
    }

    @Override
    @NonNull
    public List<Argument<?>> getTypeArguments() {
        return Arrays.asList(this.beanType.getTypeParameters());
    }

    @Override
    @NonNull
    public Class<?>[] getTypeParameters() {
        return (Class[])this.getTypeArguments().stream().map(TypeInformation::getType).toArray(Class[]::new);
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public T instantiate(BeanResolutionContext resolutionContext, BeanContext context) throws BeanInstantiationException {
        return this.supplier.get();
    }

    static final class RuntimeBeanBuilder<B>
    implements RuntimeBeanDefinition.Builder<B> {
        private Argument<B> beanType;
        private final Supplier<B> supplier;
        private Qualifier<B> qualifier;
        private boolean singleton;
        private AnnotationMetadata annotationMetadata;
        private Class<? extends Annotation> scope;
        private Class<?>[] exposedTypes = ReflectionUtils.EMPTY_CLASS_ARRAY;
        private Map<Class<?>, List<Argument<?>>> typeArguments;
        private Class<? extends B> replacesType;

        RuntimeBeanBuilder(Argument<B> beanType, Supplier<B> supplier) {
            this.beanType = Objects.requireNonNull(beanType, DefaultRuntimeBeanDefinition.MSG_BEAN_TYPE_CANNOT_BE_NULL);
            this.supplier = Objects.requireNonNull(supplier, "Bean supplier cannot be null");
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> qualifier(Qualifier<B> qualifier) {
            this.qualifier = qualifier;
            if (qualifier instanceof TypeArgumentQualifier) {
                TypeArgumentQualifier typeArgumentQualifier = (TypeArgumentQualifier)qualifier;
                Argument[] arguments = (Argument[])Arrays.stream(typeArgumentQualifier.getTypeArguments()).map(Argument::of).toArray(Argument[]::new);
                this.typeArguments(arguments);
            }
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> replaces(Class<? extends B> otherType) {
            this.replacesType = otherType;
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> scope(Class<? extends Annotation> scope) {
            this.scope = scope;
            if (scope != null && scope.getSimpleName().equals("Singleton")) {
                this.singleton = true;
            }
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> singleton(boolean isSingleton) {
            this.singleton = true;
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> exposedTypes(Class<?> ... types) {
            for (Class<?> type : types) {
                if (type.isAssignableFrom(this.beanType.getType())) continue;
                throw new IllegalArgumentException("Bean type doesn't implement: " + type.getName());
            }
            this.exposedTypes = types;
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> typeArguments(Argument<?> ... arguments) {
            this.beanType = Argument.of((Class)this.beanType.getType(), arguments);
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> typeArguments(Class<?> implementedType, Argument<?> ... arguments) {
            if (this.typeArguments == null) {
                this.typeArguments = new LinkedHashMap(5);
            }
            this.typeArguments.put(implementedType, List.of(arguments));
            return this;
        }

        @Override
        public RuntimeBeanDefinition.Builder<B> annotationMetadata(AnnotationMetadata annotationMetadata) {
            this.annotationMetadata = annotationMetadata;
            return this;
        }

        @Override
        @NonNull
        public RuntimeBeanDefinition<B> build() {
            if (this.replacesType != null) {
                MutableAnnotationMetadata mutableAnnotationMetadata;
                AnnotationMetadata annotationMetadata = this.annotationMetadata;
                if (annotationMetadata instanceof MutableAnnotationMetadata) {
                    MutableAnnotationMetadata mm;
                    mutableAnnotationMetadata = mm = (MutableAnnotationMetadata)annotationMetadata;
                } else if (this.annotationMetadata == null || this.annotationMetadata == AnnotationMetadata.EMPTY_METADATA) {
                    mutableAnnotationMetadata = new MutableAnnotationMetadata();
                    this.annotationMetadata = mutableAnnotationMetadata;
                } else {
                    throw new IllegalStateException("Previous non-mutable annotation metadata set");
                }
                HashMap<CharSequence, Object> values = new HashMap<CharSequence, Object>(3);
                values.put("value", new AnnotationClassValue(this.replacesType));
                Qualifier<B> qualifier = this.qualifier;
                if (qualifier instanceof Named) {
                    Named named = (Named)qualifier;
                    values.put("named", named.getName());
                }
                mutableAnnotationMetadata.addAnnotation(Replaces.class.getName(), values);
            }
            return new DefaultRuntimeBeanDefinition<B>(this.beanType, this.supplier, this.qualifier, this.annotationMetadata, this.singleton, this.scope, this.exposedTypes, this.typeArguments);
        }
    }
}

