/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.scope;

import io.micronaut.context.BeanRegistration;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.exceptions.BeanDestructionException;
import io.micronaut.context.scope.BeanCreationContext;
import io.micronaut.context.scope.CreatedBean;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanIdentifier;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConcurrentCustomScope<A extends Annotation>
implements CustomScope<A>,
LifeCycle<AbstractConcurrentCustomScope<A>>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConcurrentCustomScope.class);
    private final Class<A> annotationType;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    protected AbstractConcurrentCustomScope(Class<A> annotationType) {
        this.annotationType = Objects.requireNonNull(annotationType, "Annotation type cannot be null");
    }

    @NonNull
    protected abstract Map<BeanIdentifier, CreatedBean<?>> getScopeMap(boolean var1);

    @Override
    public final Class<A> annotationType() {
        return this.annotationType;
    }

    @Override
    public abstract void close();

    @Override
    @NonNull
    public final AbstractConcurrentCustomScope<A> stop() {
        this.w.lock();
        try {
            Map<BeanIdentifier, CreatedBean<?>> scopeMap = this.getScopeMap(false);
            this.destroyScope(scopeMap);
            this.close();
            AbstractConcurrentCustomScope abstractConcurrentCustomScope = this;
            return abstractConcurrentCustomScope;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyScope(@Nullable Map<BeanIdentifier, CreatedBean<?>> scopeMap) {
        this.w.lock();
        try {
            if (CollectionUtils.isNotEmpty(scopeMap)) {
                for (CreatedBean<?> createdBean : scopeMap.values()) {
                    try {
                        createdBean.close();
                    }
                    catch (BeanDestructionException e) {
                        this.handleDestructionException(e);
                    }
                }
                scopeMap.clear();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T getOrCreate(BeanCreationContext<T> creationContext) {
        this.r.lock();
        try {
            CreatedBean<Object> createdBean;
            BeanIdentifier id;
            Map<BeanIdentifier, CreatedBean<?>> scopeMap;
            block10: {
                Object obj;
                scopeMap = this.getScopeMap(true);
                id = creationContext.id();
                createdBean = scopeMap.get(id);
                if (createdBean != null) {
                    Object obj2 = createdBean.bean();
                    return (T)obj2;
                }
                this.r.unlock();
                this.w.lock();
                try {
                    createdBean = scopeMap.get(id);
                    if (createdBean == null) break block10;
                    this.r.lock();
                    obj = createdBean.bean();
                    this.w.unlock();
                }
                catch (Throwable throwable) {
                    this.w.unlock();
                    throw throwable;
                }
                return (T)obj;
            }
            createdBean = this.doCreate(creationContext);
            scopeMap.put(id, createdBean);
            this.r.lock();
            Object object = createdBean.bean();
            this.w.unlock();
            return (T)object;
        }
        finally {
            this.r.unlock();
        }
    }

    @NonNull
    protected <T> CreatedBean<T> doCreate(@NonNull BeanCreationContext<T> creationContext) {
        return creationContext.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Optional<T> remove(BeanIdentifier identifier) {
        if (identifier == null) {
            return Optional.empty();
        }
        this.w.lock();
        try {
            Map<BeanIdentifier, CreatedBean<?>> scopeMap = this.getScopeMap(false);
            if (CollectionUtils.isNotEmpty(scopeMap)) {
                CreatedBean<?> createdBean = scopeMap.get(identifier);
                if (createdBean != null) {
                    try {
                        createdBean.close();
                    }
                    catch (BeanDestructionException e) {
                        this.handleDestructionException(e);
                    }
                    Optional<?> optional = Optional.ofNullable(createdBean.bean());
                    return optional;
                }
                Optional optional = Optional.empty();
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.w.unlock();
        }
    }

    protected void handleDestructionException(BeanDestructionException e) {
        LOG.error("Error occurred destroying bean of scope @" + this.annotationType.getSimpleName() + ": " + e.getMessage(), (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        this.r.lock();
        try {
            for (CreatedBean<?> createdBean : this.getScopeMap(false).values()) {
                if (createdBean.bean() != bean) continue;
                Optional<BeanRegistration<T>> optional = Optional.of(new BeanRegistration(createdBean.id(), createdBean.definition(), bean));
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.r.unlock();
        }
    }
}

