/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Vetoed;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.processing.BeanDefinitionCreator;
import io.micronaut.inject.processing.BeanDefinitionCreatorFactory;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.BeanElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Internal
@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations", "micronaut.processing.omit.confprop.injectpoints"})
public class BeanDefinitionInjectProcessor
extends AbstractInjectAnnotationProcessor {
    private static final String[] ANNOTATION_STEREOTYPES = new String[]{"jakarta.annotation.PostConstruct", "jakarta.annotation.PreDestroy", "jakarta.annotation.PreDestroy", "jakarta.annotation.PostConstruct", "jakarta.inject.Inject", "jakarta.inject.Qualifier", "jakarta.inject.Singleton", "jakarta.inject.Inject", "jakarta.inject.Qualifier", "jakarta.inject.Singleton", "io.micronaut.context.annotation.Bean", "io.micronaut.context.annotation.Replaces", "io.micronaut.context.annotation.Value", "io.micronaut.context.annotation.Property", "io.micronaut.context.annotation.Executable", "io.micronaut.aop.Around", "io.micronaut.aop.InterceptorBindingDefinitions", "io.micronaut.aop.InterceptorBinding", "io.micronaut.aop.Introduction"};
    private Set<String> beanDefinitions;
    private final Set<String> processed = new HashSet<String>();
    private final Map<String, PostponeToNextRoundException> postponed = new HashMap<String, PostponeToNextRoundException>();

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.beanDefinitions = new LinkedHashSet<String>();
        for (BeanElementVisitor visitor : BeanElementVisitor.VISITORS) {
            if (!visitor.isEnabled()) continue;
            try {
                visitor.start((VisitorContext)this.javaVisitorContext);
            }
            catch (Exception e) {
                this.javaVisitorContext.fail("Error initializing bean element visitor [" + visitor.getClass().getName() + "]: " + e.getMessage(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean processingOver = roundEnv.processingOver();
        if (!processingOver) {
            JavaAnnotationMetadataBuilder annotationMetadataBuilder = this.javaVisitorContext.getAnnotationMetadataBuilder();
            if (!(annotations = annotations.stream().filter(ann -> {
                String name = ann.getQualifiedName().toString();
                String packageName = NameUtils.getPackageName((String)name);
                return !name.equals("kotlin.Metadata") && !AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName);
            }).filter(ann -> annotationMetadataBuilder.lookupOrBuildForType(ann).hasStereotype(ANNOTATION_STEREOTYPES) || this.isProcessedAnnotation(ann.getQualifiedName().toString())).collect(Collectors.toSet())).isEmpty()) {
                TypeElement typeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
                TypeMirror groovyObjectType = typeElement != null ? typeElement.asType() : null;
                annotations.forEach(annotation -> this.modelUtils.resolveTypeElements(roundEnv.getElementsAnnotatedWith((TypeElement)annotation)).forEach(typeElement -> {
                    if (typeElement.getKind() == ElementKind.ENUM) {
                        AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata am = annotationMetadataBuilder.lookupOrBuildForType(typeElement);
                        if (BeanDefinitionCreatorFactory.isDeclaredBeanInMetadata((AnnotationMetadata)am)) {
                            this.error((Element)typeElement, "Enum types cannot be defined as beans", new Object[0]);
                        }
                        return;
                    }
                    if (groovyObjectType != null && this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType)) {
                        return;
                    }
                    String name = typeElement.getQualifiedName().toString();
                    if (this.beanDefinitions.contains(name) || this.processed.contains(name) || name.endsWith("$Intercepted")) {
                        return;
                    }
                    boolean isInterface = JavaModelUtils.resolveKind((Element)typeElement, (ElementKind)ElementKind.INTERFACE).isPresent();
                    if (!isInterface) {
                        this.beanDefinitions.add(name);
                    } else {
                        AbstractAnnotationMetadataBuilder.CachedAnnotationMetadata annotationMetadata = annotationMetadataBuilder.lookupOrBuildForType(typeElement);
                        if (BeanDefinitionCreatorFactory.isIntroduction((AnnotationMetadata)annotationMetadata) || annotationMetadata.hasStereotype(ConfigurationReader.class)) {
                            this.beanDefinitions.add(name);
                        }
                    }
                }));
            }
            for (String name : this.processed) {
                this.beanDefinitions.remove(name);
                this.postponed.remove(name);
            }
            int n = this.beanDefinitions.size();
            if (n > 0) {
                ElementAnnotationMetadataFactory annotationMetadataFactory = this.javaVisitorContext.getElementAnnotationMetadataFactory().readOnly();
                for (String className : this.beanDefinitions) {
                    if (!this.processed.add(className)) continue;
                    TypeElement typeElement = this.elementUtils.getTypeElement(className);
                    try {
                        JavaClassElement classElement;
                        Name classElementQualifiedName = typeElement.getQualifiedName();
                        if ("java.lang.Record".equals(classElementQualifiedName.toString()) || (classElement = this.javaVisitorContext.getElementFactory().newClassElement(typeElement, annotationMetadataFactory)).hasAnnotation(Vetoed.class) || classElement.getPackage().hasAnnotation(Vetoed.class)) continue;
                        BeanDefinitionCreator beanDefinitionCreator = BeanDefinitionCreatorFactory.produce((ClassElement)classElement, (VisitorContext)this.javaVisitorContext);
                        for (BeanDefinitionVisitor writer : beanDefinitionCreator.build()) {
                            if (this.processed.contains(writer.getBeanDefinitionName())) {
                                throw new IllegalStateException("Already processed: " + writer.getBeanDefinitionName());
                            }
                            this.processBeanDefinitions(writer);
                            this.processed.add(writer.getBeanDefinitionName());
                        }
                    }
                    catch (ProcessingException ex) {
                        this.error(((JavaNativeElement)ex.getOriginatingElement()).element(), ex.getMessage(), new Object[0]);
                    }
                    catch (PostponeToNextRoundException e) {
                        this.processed.remove(className);
                        this.postponed.put(className, e);
                    }
                }
            }
        }
        if (processingOver) {
            for (Map.Entry entry : this.postponed.entrySet()) {
                this.javaVisitorContext.warn("Bean definition generation [" + (String)entry.getKey() + "] skipped from processing because of prior error: [" + ((PostponeToNextRoundException)entry.getValue()).getPath() + "]. This error is normally due to missing classes on the classpath. Verify the compilation classpath is correct to resolve the problem.", (Element)((PostponeToNextRoundException)entry.getValue()).getErrorElement());
            }
            try {
                this.writeBeanDefinitionsToMetaInf();
                for (BeanElementVisitor beanElementVisitor : BeanElementVisitor.VISITORS) {
                    if (!beanElementVisitor.isEnabled()) continue;
                    try {
                        beanElementVisitor.finish((VisitorContext)this.javaVisitorContext);
                    }
                    catch (Exception e) {
                        this.javaVisitorContext.fail("Error finalizing bean element visitor [" + beanElementVisitor.getClass().getName() + "]: " + e.getMessage(), null);
                    }
                }
                List<AbstractBeanDefinitionBuilder> beanElementBuilders = this.javaVisitorContext.getBeanElementBuilders();
                if (CollectionUtils.isNotEmpty(beanElementBuilders)) {
                    try {
                        AbstractBeanDefinitionBuilder.writeBeanDefinitionBuilders((ClassWriterOutputVisitor)this.classWriterOutputVisitor, beanElementBuilders);
                    }
                    catch (IOException iOException) {
                        String message = iOException.getMessage();
                        this.error("Unexpected error: %s", message != null ? message : iOException.getClass().getSimpleName());
                    }
                }
            }
            finally {
                BeanDefinitionWriter.finish();
            }
        }
        return false;
    }

    private void writeBeanDefinitionsToMetaInf() {
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.error("Error occurred writing META-INF files: %s", message != null ? message : e);
        }
    }

    private void processBeanDefinitions(BeanDefinitionVisitor beanDefinitionWriter) {
        try {
            beanDefinitionWriter.visitBeanDefinitionEnd();
            if (beanDefinitionWriter.isEnabled()) {
                beanDefinitionWriter.accept((ClassWriterOutputVisitor)this.classWriterOutputVisitor);
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            this.error("Unexpected error: %s", message != null ? message : e.getClass().getSimpleName());
        }
    }
}

