/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.exceptions;

import io.micronaut.http.exceptions.HttpException;

public final class BufferLengthExceededException
extends HttpException {
    private final long advertisedLength;
    private final long receivedLength;

    public BufferLengthExceededException(long advertisedLength, long receivedLength) {
        super("The content length [%d] exceeds the maximum allowed bufferable length [%d]. Note that the maximum buffer size got its own configuration property (micronaut.server.max-request-buffer-size) in 4.5.0 that you may have to configure. Alternatively you can rewrite your controller to stream the request instead of buffering it.".formatted(receivedLength, advertisedLength));
        this.advertisedLength = advertisedLength;
        this.receivedLength = receivedLength;
    }

    public long getAdvertisedLength() {
        return this.advertisedLength;
    }

    public long getReceivedLength() {
        return this.receivedLength;
    }
}

