/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieComparator;
import io.micronaut.http.cookie.SameSite;
import java.net.HttpCookie;
import java.util.Optional;

@Internal
class CookieHttpCookieAdapter
implements Cookie {
    private static final CookieComparator COMPARATOR = new CookieComparator();
    private final HttpCookie httpCookie;
    private SameSite sameSite = null;

    public CookieHttpCookieAdapter(HttpCookie httpCookie) {
        this.httpCookie = httpCookie;
    }

    @Override
    @NonNull
    public String getName() {
        return this.httpCookie.getName();
    }

    @Override
    @NonNull
    public String getValue() {
        return this.httpCookie.getValue();
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.httpCookie.getDomain();
    }

    @Override
    @Nullable
    public String getPath() {
        return this.httpCookie.getPath();
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpCookie.isHttpOnly();
    }

    @Override
    public boolean isSecure() {
        return this.httpCookie.getSecure();
    }

    @Override
    public long getMaxAge() {
        return this.httpCookie.getMaxAge();
    }

    @Override
    @NonNull
    public Cookie maxAge(long maxAge) {
        this.httpCookie.setMaxAge(maxAge);
        return this;
    }

    @Override
    @NonNull
    public Cookie value(@NonNull String value) {
        this.httpCookie.setValue(value);
        return this;
    }

    @Override
    @NonNull
    public Cookie domain(@Nullable String domain) {
        this.httpCookie.setDomain(domain);
        return this;
    }

    @Override
    @NonNull
    public Cookie path(@Nullable String path) {
        this.httpCookie.setPath(path);
        return this;
    }

    @Override
    @NonNull
    public Cookie secure(boolean secure) {
        this.httpCookie.setSecure(secure);
        return this;
    }

    @Override
    @NonNull
    public Cookie httpOnly(boolean httpOnly) {
        this.httpCookie.setHttpOnly(httpOnly);
        return this;
    }

    @Override
    public Optional<SameSite> getSameSite() {
        return Optional.ofNullable(this.sameSite);
    }

    @Override
    public Cookie sameSite(SameSite sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public int compareTo(Cookie o) {
        return COMPARATOR.compare(this, o);
    }
}

