/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

@Internal
class ResettableReadTimeoutHandler
extends ReadTimeoutHandler {
    private static final Object FAKE_MESSAGE = new Object();
    private ChannelHandlerContext ctx;
    private boolean reading = false;

    public ResettableReadTimeoutHandler(long timeout, TimeUnit unit) {
        super(timeout, unit);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        ctx.pipeline().addAfter(ctx.name(), ctx.name() + "-reset-interceptor", (ChannelHandler)NextInterceptor.INSTANCE);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        try {
            ctx.pipeline().remove(ctx.name() + "-reset-interceptor");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.reading = true;
        super.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.reading = false;
        super.channelReadComplete(ctx);
    }

    void resetReadTimeoutMn() {
        if (!this.reading) {
            try {
                this.channelRead(this.ctx, FAKE_MESSAGE);
                this.channelReadComplete(this.ctx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ChannelHandler.Sharable
    private static class NextInterceptor
    extends ChannelInboundHandlerAdapter {
        static final NextInterceptor INSTANCE = new NextInterceptor();

        private NextInterceptor() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg == FAKE_MESSAGE) {
                return;
            }
            super.channelRead(ctx, msg);
        }
    }
}

