/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
final class ReactiveClientWriter
extends ChannelInboundHandlerAdapter
implements Subscriber<HttpContent> {
    private final Publisher<HttpContent> source;
    private EventLoop eventLoop;
    private ChannelHandlerContext ctx;
    private Subscription subscription;
    private boolean writtenLast;

    ReactiveClientWriter(Publisher<HttpContent> source) {
        this.source = source;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.eventLoop = ctx.channel().eventLoop();
        this.ctx = ctx;
        this.source.subscribe((Subscriber)this);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.ctx = null;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        if (ctx.channel().isWritable()) {
            this.subscription.request(1L);
        }
    }

    public void onSubscribe(Subscription s) {
        if (!this.eventLoop.inEventLoop()) {
            this.eventLoop.execute(() -> this.onSubscribe(s));
            return;
        }
        if (this.ctx == null) {
            s.cancel();
        } else {
            this.subscription = s;
            if (this.ctx.channel().isWritable()) {
                this.subscription.request(1L);
            }
        }
    }

    public void onNext(HttpContent httpContent) {
        if (!this.eventLoop.inEventLoop()) {
            this.eventLoop.execute(() -> this.onNext(httpContent));
            return;
        }
        if (this.writtenLast) {
            throw new IllegalStateException("Already written a LastHttpContent");
        }
        if (this.ctx == null) {
            httpContent.release();
            return;
        }
        if (httpContent instanceof LastHttpContent) {
            this.writtenLast = true;
        }
        this.ctx.writeAndFlush((Object)httpContent, this.ctx.voidPromise());
        if (this.ctx.channel().isWritable()) {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable t) {
        if (!this.eventLoop.inEventLoop()) {
            this.eventLoop.execute(() -> this.onError(t));
            return;
        }
        this.ctx.fireExceptionCaught(t);
        this.ctx.pipeline().remove(this.ctx.name());
    }

    public void onComplete() {
        if (!this.eventLoop.inEventLoop()) {
            this.eventLoop.execute(this::onComplete);
            return;
        }
        if (!this.writtenLast) {
            this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.ctx.voidPromise());
        }
        this.ctx.pipeline().remove(this.ctx.name());
    }
}

