/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.filter;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

@Internal
@Singleton
@BootstrapContextCompatible
public class DefaultHttpClientFilterResolver
implements HttpClientFilterResolver<ClientFilterResolutionContext> {
    private final List<HttpClientFilter> clientFilters;
    private final AnnotationMetadataResolver annotationMetadataResolver;

    public DefaultHttpClientFilterResolver(AnnotationMetadataResolver annotationMetadataResolver, List<HttpClientFilter> clientFilters) {
        this.annotationMetadataResolver = annotationMetadataResolver;
        this.clientFilters = clientFilters;
    }

    public List<HttpFilterResolver.FilterEntry<HttpClientFilter>> resolveFilterEntries(ClientFilterResolutionContext context) {
        return this.clientFilters.stream().map(httpClientFilter -> {
            AnnotationMetadata annotationMetadata = this.annotationMetadataResolver.resolveMetadata(httpClientFilter);
            HttpMethod[] methods = (HttpMethod[])annotationMetadata.enumValues(Filter.class, "methods", HttpMethod.class);
            HashSet<HttpMethod> httpMethods = new HashSet<HttpMethod>(Arrays.asList(methods));
            if (annotationMetadata.hasStereotype(FilterMatcher.class)) {
                httpMethods.addAll(Arrays.asList(annotationMetadata.enumValues(FilterMatcher.class, "methods", HttpMethod.class)));
            }
            return HttpFilterResolver.FilterEntry.of((HttpFilter)httpClientFilter, (AnnotationMetadata)annotationMetadata, httpMethods, (String[])annotationMetadata.stringValues(Filter.class));
        }).filter(entry -> {
            Object[] clients;
            boolean hasClients;
            AnnotationMetadata annotationMetadata = entry.getAnnotationMetadata();
            boolean matches = !annotationMetadata.hasStereotype(FilterMatcher.class);
            String filterAnnotation = annotationMetadata.getAnnotationNameByStereotype(FilterMatcher.class).orElse(null);
            if (filterAnnotation != null && !matches) {
                matches = context.getAnnotationMetadata().hasStereotype(filterAnnotation);
            }
            if (matches && (hasClients = ArrayUtils.isNotEmpty((Object[])(clients = annotationMetadata.stringValues(Filter.class, "serviceId"))))) {
                matches = this.containsIdentifier(context.getClientIds(), (String[])clients);
            }
            return matches;
        }).collect(Collectors.toList());
    }

    public List<HttpClientFilter> resolveFilters(HttpRequest<?> request, List<HttpFilterResolver.FilterEntry<HttpClientFilter>> filterEntries) {
        String requestPath = StringUtils.prependUri((String)"/", (String)request.getUri().getPath());
        HttpMethod method = request.getMethod();
        ArrayList<HttpClientFilter> filterList = new ArrayList<HttpClientFilter>(filterEntries.size());
        for (HttpFilterResolver.FilterEntry<HttpClientFilter> filterEntry : filterEntries) {
            HttpClientFilter filter = (HttpClientFilter)filterEntry.getFilter();
            if (filter instanceof Toggleable && !((Toggleable)filter).isEnabled()) continue;
            boolean matches = true;
            if (filterEntry.hasMethods()) {
                matches = this.anyMethodMatches(method, filterEntry.getFilterMethods());
            }
            if (filterEntry.hasPatterns()) {
                boolean bl = matches = matches && this.anyPatternMatches(requestPath, filterEntry.getPatterns());
            }
            if (!matches) continue;
            filterList.add(filter);
        }
        return filterList;
    }

    private boolean containsIdentifier(Collection<String> clientIdentifiers, String[] clients) {
        return Arrays.stream(clients).anyMatch(clientIdentifiers::contains);
    }

    private boolean anyPatternMatches(String requestPath, String[] patterns) {
        return Arrays.stream(patterns).anyMatch(pattern -> PathMatcher.ANT.matches(pattern, requestPath));
    }

    private boolean anyMethodMatches(HttpMethod requestMethod, Collection<HttpMethod> methods) {
        return methods.contains(requestMethod);
    }
}

