/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.annotation.Internal;

@Internal
public final class StringIntMap {
    private final int mask;
    private final String[] keys;
    private final int[] values;

    public StringIntMap(int size) {
        int tableSize = size * 2 + 1;
        tableSize = Integer.highestOneBit(tableSize) * 2;
        this.mask = tableSize - 1;
        this.keys = new String[tableSize];
        this.values = new int[this.keys.length];
    }

    private int probe(String key) {
        int n = this.keys.length;
        int i = key.hashCode() & this.mask;
        String candidate;
        while ((candidate = this.keys[i]) != null) {
            if (candidate.equals(key)) {
                return i;
            }
            if (++i != n) continue;
            i = 0;
        }
        return ~i;
    }

    public int get(String key, int def) {
        int i = this.probe(key);
        return i < 0 ? def : this.values[i];
    }

    public void put(String key, int value) {
        int tableIndex = ~this.probe(key);
        if (tableIndex < 0) {
            throw new IllegalArgumentException("Duplicate key");
        }
        this.keys[tableIndex] = key;
        this.values[tableIndex] = value;
    }
}

