/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ObjectUtils;
import java.util.Objects;

@Internal
final class DefaultBeanWrapper<T>
implements BeanWrapper<T> {
    private final T bean;
    private final BeanIntrospection<T> introspection;

    DefaultBeanWrapper(@NonNull T bean, @NonNull BeanIntrospection<T> introspection) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("introspection", introspection);
        this.bean = bean;
        this.introspection = introspection;
    }

    @Override
    @NonNull
    public BeanIntrospection<T> getIntrospection() {
        return this.introspection;
    }

    @Override
    @NonNull
    public T getBean() {
        return this.bean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBeanWrapper that = (DefaultBeanWrapper)o;
        return Objects.equals(this.bean, that.bean) && Objects.equals(this.introspection, that.introspection);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.bean, this.introspection);
    }
}

