/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;

public interface BeanReadProperty<B, T>
extends AnnotatedElement,
AnnotationMetadataDelegate,
ArgumentCoercible<T> {
    @NonNull
    public BeanIntrospection<B> getDeclaringBean();

    default public Class<B> getDeclaringType() {
        return this.getDeclaringBean().getBeanType();
    }

    @Nullable
    public T get(@NonNull B var1);

    @NonNull
    default public <T2> Optional<T2> get(@NonNull B bean, @NonNull Class<T2> type) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", type);
        Argument<T2> argument = Argument.of(type);
        return this.get(bean, argument);
    }

    default public <T2> Optional<T2> get(@NonNull B bean, @NonNull Argument<T2> argument) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", argument);
        ArgumentConversionContext<T2> conversionContext = ConversionContext.of(argument);
        return this.get(bean, conversionContext);
    }

    default public <T2> Optional<T2> get(@NonNull B bean, @NonNull ArgumentConversionContext<T2> conversionContext) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("conversionContext", conversionContext);
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, conversionContext);
    }

    @Nullable
    default public <T2> T2 get(@NonNull B bean, @NonNull Class<T2> type, @Nullable T2 defaultValue) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (type == null) {
            return defaultValue;
        }
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, type).orElse(defaultValue);
    }

    @NonNull
    public Class<T> getType();

    @Override
    @NonNull
    default public Argument<T> asArgument() {
        return Argument.of(this.getType());
    }
}

