/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.beans.DefaultBeanIntrospector;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;

public interface BeanIntrospector {
    public static final BeanIntrospector SHARED = new DefaultBeanIntrospector();

    public static BeanIntrospector forClassLoader(ClassLoader classLoader) {
        return new DefaultBeanIntrospector(classLoader);
    }

    @NonNull
    public Collection<BeanIntrospection<Object>> findIntrospections(@NonNull Predicate<? super BeanIntrospectionReference<?>> var1);

    @NonNull
    public Collection<Class<?>> findIntrospectedTypes(@NonNull Predicate<? super BeanIntrospectionReference<?>> var1);

    @NonNull
    public <T> Optional<BeanIntrospection<T>> findIntrospection(@NonNull Class<T> var1);

    @NonNull
    default public Collection<BeanIntrospection<Object>> findIntrospections(@NonNull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.findIntrospections((? super BeanIntrospectionReference<?> ref) -> ref.getAnnotationMetadata().hasStereotype(stereotype));
    }

    @NonNull
    default public Collection<BeanIntrospection<Object>> findIntrospections(@NonNull Class<? extends Annotation> stereotype, String ... packageNames) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        ArgumentUtils.requireNonNull("packageNames", packageNames);
        return this.findIntrospections((? super BeanIntrospectionReference<?> ref) -> ref.getAnnotationMetadata().hasStereotype(stereotype) && Arrays.stream(packageNames).anyMatch(s -> ref.getName().startsWith(s + ".")));
    }

    @NonNull
    default public <T> BeanIntrospection<T> getIntrospection(@NonNull Class<T> beanType) {
        return this.findIntrospection(beanType).orElseThrow(() -> new IntrospectionException("No bean introspection available for type [" + beanType + "]. Ensure the class is annotated with io.micronaut.core.annotation.Introspected"));
    }
}

