/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.DefaultServiceDefinition;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.reflect.ClassUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.Predicate;

public final class SoftServiceLoader<S>
implements Iterable<ServiceDefinition<S>> {
    public static final String META_INF_SERVICES = "META-INF/services";
    private final Class<S> serviceType;
    private final ClassLoader classLoader;
    private final Map<String, ServiceDefinition<S>> loadedServices = new LinkedHashMap<String, ServiceDefinition<S>>();
    private final Iterator<ServiceDefinition<S>> unloadedServices;
    private final Predicate<String> condition;

    private SoftServiceLoader(Class<S> serviceType, ClassLoader classLoader) {
        this(serviceType, classLoader, name -> true);
    }

    private SoftServiceLoader(Class<S> serviceType, ClassLoader classLoader, Predicate<String> condition) {
        this.serviceType = serviceType;
        this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.unloadedServices = new ServiceLoaderIterator();
        this.condition = condition == null ? name -> true : condition;
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service) {
        return SoftServiceLoader.load(service, SoftServiceLoader.class.getClassLoader());
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new SoftServiceLoader<S>(service, loader);
    }

    public static <S> SoftServiceLoader<S> load(Class<S> service, ClassLoader loader, Predicate<String> condition) {
        return new SoftServiceLoader<S>(service, loader, condition);
    }

    public Optional<ServiceDefinition<S>> first() {
        Iterator<ServiceDefinition<S>> i = this.iterator();
        if (i.hasNext()) {
            return Optional.of(i.next());
        }
        return Optional.empty();
    }

    public Optional<ServiceDefinition<S>> firstOr(String alternative, ClassLoader classLoader) {
        Iterator<ServiceDefinition<S>> i = this.iterator();
        if (i.hasNext()) {
            return Optional.of(i.next());
        }
        Optional<Class> alternativeClass = ClassUtils.forName(alternative, classLoader);
        if (alternativeClass.isPresent()) {
            return Optional.of(this.newService(alternative, alternativeClass));
        }
        return Optional.empty();
    }

    public void collectAll(@NonNull Collection<S> values, @Nullable Predicate<S> predicate) {
        ServicesLoader<S> servicesLoader = new ServicesLoader<S>(this.serviceType.getName(), this.condition, this.classLoader, predicate);
        ForkJoinPool.commonPool().invoke(servicesLoader);
        servicesLoader.collect(values);
    }

    public void collectAll(@NonNull Collection<S> values) {
        this.collectAll(values, null);
    }

    @Override
    public Iterator<ServiceDefinition<S>> iterator() {
        return new Iterator<ServiceDefinition<S>>(){
            Iterator<ServiceDefinition<S>> loaded;
            {
                this.loaded = SoftServiceLoader.this.loadedServices.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.loaded.hasNext()) {
                    return true;
                }
                return SoftServiceLoader.this.unloadedServices.hasNext();
            }

            @Override
            public ServiceDefinition<S> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.loaded.hasNext()) {
                    return this.loaded.next();
                }
                if (SoftServiceLoader.this.unloadedServices.hasNext()) {
                    ServiceDefinition nextService = (ServiceDefinition)SoftServiceLoader.this.unloadedServices.next();
                    SoftServiceLoader.this.loadedServices.put(nextService.getName(), nextService);
                    return nextService;
                }
                throw new Error("Bug in iterator");
            }
        };
    }

    protected ServiceDefinition<S> newService(String name, Optional<Class> loadedClass) {
        return new DefaultServiceDefinition(name, loadedClass);
    }

    private static abstract class RecursiveActionValuesCollector<S>
    extends RecursiveAction {
        private RecursiveActionValuesCollector() {
        }

        public abstract void collect(Collection<S> var1);
    }

    private static class ServiceInstanceLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final String className;
        private final ClassLoader classLoader;
        private final Predicate<S> predicate;
        private S result;
        private Throwable throwable;

        public ServiceInstanceLoader(String className, ClassLoader classLoader, Predicate<S> predicate) {
            this.className = className;
            this.classLoader = classLoader;
            this.predicate = predicate;
        }

        @Override
        protected void compute() {
            try {
                Class<?> loadedClass = Class.forName(this.className, false, this.classLoader);
                this.result = loadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (this.predicate != null && !this.predicate.test(this.result)) {
                    this.result = null;
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError loadedClass) {
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        @Override
        public void collect(Collection<S> values) {
            if (this.throwable != null) {
                throw new RuntimeException("Failed to load a service: " + this.throwable.getMessage(), this.throwable);
            }
            if (this.result != null) {
                values.add(this.result);
            }
        }
    }

    private static class UrlServicesLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final URL url;
        private final Predicate<String> lineCondition;
        private final ClassLoader classLoader;
        private final Predicate<S> predicate;
        private final List<ServiceInstanceLoader<S>> tasks = new LinkedList<ServiceInstanceLoader<S>>();

        public UrlServicesLoader(URL url, Predicate<String> lineCondition, ClassLoader classLoader, Predicate<S> predicate) {
            this.url = url;
            this.lineCondition = lineCondition;
            this.classLoader = classLoader;
            this.predicate = predicate;
        }

        @Override
        protected void compute() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.url.openStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0 || line.charAt(0) == '#' || !this.lineCondition.test(line)) continue;
                    int i = line.indexOf(35);
                    if (i > -1) {
                        line = line.substring(0, i);
                    }
                    ServiceInstanceLoader<S> task = new ServiceInstanceLoader<S>(line, this.classLoader, this.predicate);
                    this.tasks.add(task);
                    task.fork();
                }
            }
            catch (IOException | UncheckedIOException exception) {
                // empty catch block
            }
        }

        @Override
        public void collect(Collection<S> values) {
            for (ServiceInstanceLoader<S> task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }
    }

    private static class ServicesLoader<S>
    extends RecursiveActionValuesCollector<S> {
        private final String serviceName;
        private final Predicate<String> lineCondition;
        private final ClassLoader classLoader;
        private final Predicate<S> predicate;
        private final List<RecursiveActionValuesCollector<S>> tasks = new LinkedList<RecursiveActionValuesCollector<S>>();

        public ServicesLoader(String serviceName, Predicate<String> lineCondition, ClassLoader classLoader, Predicate<S> predicate) {
            this.serviceName = serviceName;
            this.lineCondition = lineCondition;
            this.classLoader = classLoader;
            this.predicate = predicate;
        }

        @Override
        protected void compute() {
            try {
                Enumeration<URL> serviceConfigs = this.classLoader.getResources("META-INF/services/" + this.serviceName);
                while (serviceConfigs.hasMoreElements()) {
                    URL url = serviceConfigs.nextElement();
                    UrlServicesLoader<S> task = new UrlServicesLoader<S>(url, this.lineCondition, this.classLoader, this.predicate);
                    this.tasks.add(task);
                    task.fork();
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Failed to load resources for service: " + this.serviceName, e);
            }
        }

        @Override
        public void collect(Collection<S> values) {
            for (RecursiveActionValuesCollector<S> task : this.tasks) {
                task.join();
                task.collect(values);
            }
        }
    }

    private final class ServiceLoaderIterator
    implements Iterator<ServiceDefinition<S>> {
        private Enumeration<URL> serviceConfigs = null;
        private Iterator<String> unprocessed = null;

        private ServiceLoaderIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.serviceConfigs == null) {
                String name = SoftServiceLoader.this.serviceType.getName();
                try {
                    this.serviceConfigs = SoftServiceLoader.this.classLoader.getResources("META-INF/services/" + name);
                }
                catch (IOException e) {
                    throw new ServiceConfigurationError("Failed to load resources for service: " + name, e);
                }
            }
            while (this.unprocessed == null || !this.unprocessed.hasNext()) {
                if (!this.serviceConfigs.hasMoreElements()) {
                    return false;
                }
                URL url = this.serviceConfigs.nextElement();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    Throwable throwable = null;
                    try {
                        String line;
                        LinkedList<String> lines = new LinkedList<String>();
                        while ((line = reader.readLine()) != null) {
                            if (line.length() == 0 || line.charAt(0) == '#' || !SoftServiceLoader.this.condition.test(line)) continue;
                            int i = line.indexOf(35);
                            if (i > -1) {
                                line = line.substring(0, i);
                            }
                            lines.add(line);
                        }
                        this.unprocessed = lines.iterator();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException | UncheckedIOException exception) {}
            }
            return this.unprocessed.hasNext();
        }

        @Override
        public ServiceDefinition<S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String nextName = this.unprocessed.next();
            try {
                Class<?> loadedClass = Class.forName(nextName, false, SoftServiceLoader.this.classLoader);
                return SoftServiceLoader.this.newService(nextName, Optional.of(loadedClass));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                return SoftServiceLoader.this.newService(nextName, Optional.empty());
            }
        }
    }
}

