/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.TransactionDefinition;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class DefaultTransactionDefinition
implements TransactionDefinition {
    private TransactionDefinition.Propagation propagationBehavior = TransactionDefinition.Propagation.REQUIRED;
    @Nullable
    private TransactionDefinition.Isolation isolationLevel;
    @Nullable
    private Duration timeout;
    @Nullable
    private Boolean readOnly;
    @Nullable
    private String name;
    private Collection<Class<? extends Throwable>> rollbackOn = Collections.emptyList();
    private Collection<Class<? extends Throwable>> dontRollbackOn = Collections.emptyList();

    public DefaultTransactionDefinition() {
    }

    public DefaultTransactionDefinition(TransactionDefinition other) {
        this.propagationBehavior = other.getPropagationBehavior();
        this.isolationLevel = other.getIsolationLevel().orElse(null);
        this.timeout = other.getTimeout().orElse(null);
        this.readOnly = other.isReadOnly().orElse(null);
        this.name = other.getName();
        this.rollbackOn = other.getRollbackOn();
        this.dontRollbackOn = other.getDontRollbackOn();
    }

    public DefaultTransactionDefinition(@NonNull TransactionDefinition.Propagation propagationBehavior) {
        Objects.requireNonNull(propagationBehavior, "Argument [propagationBehavior] cannot be null");
        this.propagationBehavior = propagationBehavior;
    }

    public final void setPropagationBehavior(@NonNull TransactionDefinition.Propagation propagationBehavior) {
        if (propagationBehavior == null) {
            throw new IllegalArgumentException("Only values of propagation constants allowed");
        }
        this.propagationBehavior = propagationBehavior;
    }

    @Override
    @NonNull
    public final TransactionDefinition.Propagation getPropagationBehavior() {
        return this.propagationBehavior;
    }

    public final void setIsolationLevel(@NonNull TransactionDefinition.Isolation isolationLevel) {
        if (isolationLevel == null) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        if (isolationLevel == TransactionDefinition.Isolation.DEFAULT) {
            isolationLevel = null;
        }
        this.isolationLevel = isolationLevel;
    }

    @Override
    @NonNull
    public final Optional<TransactionDefinition.Isolation> getIsolationLevel() {
        return Optional.ofNullable(this.isolationLevel);
    }

    public final void setTimeout(@NonNull Duration timeout) {
        if (timeout == null || timeout.isNegative()) {
            throw new IllegalArgumentException("Timeout must be a positive integer or TIMEOUT_DEFAULT");
        }
        this.timeout = timeout;
    }

    @Override
    @NonNull
    public final Optional<Duration> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public final Optional<Boolean> isReadOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public final String getName() {
        return this.name;
    }

    public void setRollbackOn(@Nullable Collection<Class<? extends Throwable>> rollbackOn) {
        this.rollbackOn = rollbackOn == null ? Collections.emptyList() : rollbackOn;
    }

    public void setDontRollbackOn(@Nullable Collection<Class<? extends Throwable>> dontRollbackOn) {
        this.dontRollbackOn = dontRollbackOn == null ? Collections.emptyList() : dontRollbackOn;
    }

    @Override
    public Collection<Class<? extends Throwable>> getRollbackOn() {
        return this.rollbackOn;
    }

    @Override
    public Collection<Class<? extends Throwable>> getDontRollbackOn() {
        return this.dontRollbackOn;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TransactionDefinition && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append("name='").append(this.name).append('\'');
        if (this.propagationBehavior != TransactionDefinition.Propagation.REQUIRED) {
            sb.append(", propagationBehavior=").append((Object)this.propagationBehavior);
        }
        if (this.isolationLevel != null) {
            sb.append(", isolationLevel=").append((Object)this.isolationLevel);
        }
        if (this.timeout != null) {
            sb.append(", timeout=").append(this.timeout);
        }
        if (this.readOnly != null) {
            sb.append(", readOnly=").append(this.readOnly);
        }
        if (!this.rollbackOn.isEmpty()) {
            sb.append(", rollbackOn=").append(this.rollbackOn);
        }
        if (!this.dontRollbackOn.isEmpty()) {
            sb.append(", dontRollbackOn=").append(this.dontRollbackOn);
        }
        sb.append(']');
        return sb.toString();
    }
}

