/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.advice;

import com.mongodb.client.ClientSession;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.exceptions.NoConnectionException;
import io.micronaut.data.mongodb.advice.ContexualClientSessionAdvice;
import io.micronaut.data.mongodb.session.MongoConnectionOperations;
import io.micronaut.inject.ExecutableMethod;
import java.util.Optional;

@Requires(classes={ClientSession.class}, beans={MongoConnectionOperations.class})
@Prototype
@Internal
@InterceptorBean(value={ContexualClientSessionAdvice.class})
final class ContexualClientSessionInterceptor
implements MethodInterceptor<ClientSession, Object> {
    private final MongoConnectionOperations connectionOperations;

    ContexualClientSessionInterceptor(MongoConnectionOperations connectionOperations) {
        this.connectionOperations = connectionOperations;
    }

    public Object intercept(MethodInvocationContext<ClientSession, Object> context) {
        Optional connectionStatus = this.connectionOperations.findConnectionStatus();
        if (connectionStatus.isEmpty()) {
            throw NoConnectionException.notFoundInAdvice();
        }
        ExecutableMethod method = context.getExecutableMethod();
        if (method.getName().equals("close")) {
            return null;
        }
        return method.invoke((Object)((ClientSession)((ConnectionStatus)connectionStatus.get()).getConnection()), context.getParameterValues());
    }
}

