/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.connection.DefaultConnectionDefinition;
import java.time.Duration;
import java.util.Optional;

public interface ConnectionDefinition {
    public static final Propagation PROPAGATION_DEFAULT = Propagation.REQUIRED;
    public static final ConnectionDefinition DEFAULT = new DefaultConnectionDefinition("DEFAULT");
    public static final ConnectionDefinition READ_ONLY = new DefaultConnectionDefinition("READ_ONLY", true);
    public static final ConnectionDefinition REQUIRES_NEW = DEFAULT.withPropagation(Propagation.REQUIRES_NEW);

    @NonNull
    public Propagation getPropagationBehavior();

    public Optional<Duration> getTimeout();

    public Optional<Boolean> isReadOnly();

    @Nullable
    public String getName();

    @NonNull
    public ConnectionDefinition withPropagation(Propagation var1);

    @NonNull
    public ConnectionDefinition withName(String var1);

    @NonNull
    public static ConnectionDefinition of(@NonNull Propagation propagationBehaviour) {
        return new DefaultConnectionDefinition(propagationBehaviour);
    }

    @NonNull
    public static ConnectionDefinition named(@NonNull String name) {
        return new DefaultConnectionDefinition(name);
    }

    public static enum Propagation {
        REQUIRED,
        MANDATORY,
        REQUIRES_NEW;

    }
}

