/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.exporter;

import io.micrometer.tracing.Link;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public interface FinishedSpan {
    public FinishedSpan setName(String var1);

    public String getName();

    public Instant getStartTimestamp();

    public Instant getEndTimestamp();

    default public Duration getDuration() {
        return Duration.between(this.getStartTimestamp(), this.getEndTimestamp());
    }

    public FinishedSpan setTags(Map<String, String> var1);

    public Map<String, String> getTags();

    default public FinishedSpan setTypedTags(Map<String, Object> tags) {
        HashMap<String, String> map = new HashMap<String, String>();
        tags.forEach((s, o) -> {
            if (o instanceof List) {
                map.put((String)s, ((List)o).stream().map(Object::toString).collect(Collectors.joining(",")));
            } else {
                map.put((String)s, String.valueOf(o));
            }
        });
        return this.setTags(map);
    }

    default public Map<String, Object> getTypedTags() {
        return new HashMap<String, Object>(this.getTags());
    }

    public FinishedSpan setEvents(Collection<Map.Entry<Long, String>> var1);

    public Collection<Map.Entry<Long, String>> getEvents();

    public String getSpanId();

    public @Nullable String getParentId();

    public @Nullable String getRemoteIp();

    default public @Nullable String getLocalIp() {
        return null;
    }

    public FinishedSpan setLocalIp(String var1);

    public int getRemotePort();

    public FinishedSpan setRemotePort(int var1);

    public String getTraceId();

    public @Nullable Throwable getError();

    public FinishedSpan setError(Throwable var1);

    public  @Nullable Span.Kind getKind();

    public @Nullable String getRemoteServiceName();

    public FinishedSpan setRemoteServiceName(String var1);

    default public @Nullable String getLocalServiceName() {
        return null;
    }

    default public FinishedSpan setLocalServiceName(String localServiceName) {
        return this;
    }

    default public List<Link> getLinks() {
        return Collections.emptyList();
    }

    default public FinishedSpan addLinks(List<Link> links) {
        return this;
    }

    default public FinishedSpan addLink(Link link) {
        return this;
    }
}

