/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.contextpropagation;

import io.micrometer.common.lang.NonNull;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.BaggageView;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.contextpropagation.BaggageToPropagate;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ObservationAwareBaggageThreadLocalAccessor
implements ThreadLocalAccessor<BaggageToPropagate> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ObservationAwareBaggageThreadLocalAccessor.class);
    final Map<Thread, BaggageAndScope> baggageInScope = new ConcurrentHashMap<Thread, BaggageAndScope>();
    public static final String KEY = "micrometer.tracing.baggage";
    private final Tracer tracer;
    private final ObservationRegistry registry;

    public ObservationAwareBaggageThreadLocalAccessor(ObservationRegistry observationRegistry, Tracer tracer) {
        this.registry = observationRegistry;
        this.tracer = tracer;
    }

    public Object key() {
        return KEY;
    }

    public BaggageToPropagate getValue() {
        Map<String, String> baggage;
        Observation currentObservation = this.registry.getCurrentObservation();
        Span currentSpan = this.getCurrentSpan(currentObservation);
        Map<String, String> map = baggage = currentSpan != null ? this.tracer.getAllBaggage(currentSpan.context()) : this.tracer.getAllBaggage();
        if (log.isTraceEnabled()) {
            log.trace("Current baggage in scope in thread local [" + this.baggageInScope.get(Thread.currentThread()) + "], current baggage from tracer [" + baggage + "]");
        }
        return baggage == null || baggage.isEmpty() ? null : new BaggageToPropagate(baggage);
    }

    private Span getCurrentSpan(Observation currentObservation) {
        Span currentSpan = this.tracer.currentSpan();
        if (currentObservation != null) {
            TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)currentObservation.getContext().getOrDefault(TracingObservationHandler.TracingContext.class, (Object)new TracingObservationHandler.TracingContext());
            if (currentSpan != null && !currentSpan.equals(tracingContext.getSpan())) {
                if (log.isTraceEnabled()) {
                    log.trace("User created child spans manually and scoped them, returning [" + currentSpan + "]");
                }
                return currentSpan;
            }
            if (log.isTraceEnabled()) {
                log.trace("Span created by OTLA, picking one from context [" + tracingContext.getSpan() + "]");
            }
            return tracingContext.getSpan();
        }
        if (log.isTraceEnabled()) {
            log.trace("No span created by OTLA, retrieving current span from tracer [" + currentSpan + "]");
        }
        return currentSpan;
    }

    public void setValue(BaggageToPropagate value) {
        BaggageAndScope previousScope = this.baggageInScope.get(Thread.currentThread());
        if (log.isTraceEnabled()) {
            log.trace("Baggage to set [" + value + "]. Previous scope [" + previousScope + "]");
        }
        BaggageAndScope scope = null;
        Map<String, String> storedMap = value.getBaggage();
        Set<Map.Entry<String, String>> entries = storedMap.entrySet();
        Span span = this.tracer.currentSpan();
        if (span == null) {
            log.warn("There is no span to which we can attach baggage, will not set baggage");
            return;
        }
        scope = this.openScopeForEachBaggageEntry(entries, span, scope);
        this.baggageInScope.put(Thread.currentThread(), this.scopeRestoringBaggageAndScope(scope, previousScope));
        if (log.isTraceEnabled()) {
            log.trace("Finished setting value [" + this.baggageInScope.get(Thread.currentThread()) + "]");
        }
    }

    private BaggageAndScope openScopeForEachBaggageEntry(Set<Map.Entry<String, String>> entries, Span span, BaggageAndScope scope) {
        for (Map.Entry<String, String> entry : entries) {
            BaggageView baggage;
            if (log.isTraceEnabled()) {
                baggage = this.tracer.getBaggage(span.context(), entry.getKey());
                String previousBaggage = baggage != null ? baggage.get() : null;
                log.trace("Current span [" + span + "], previous baggage [" + previousBaggage + "]");
            }
            baggage = this.tracer.createBaggageInScope(span.context(), entry.getKey(), entry.getValue());
            if (log.isTraceEnabled()) {
                Baggage currentBaggage = this.tracer.getBaggage(span.context(), entry.getKey());
                String previousBaggage = currentBaggage != null ? currentBaggage.get() : null;
                log.trace("New baggage [" + baggage + " ] hashcode [" + baggage.hashCode() + "]. Entry to set [" + entry.getValue() + "] already stored value [" + previousBaggage + "]");
            }
            scope = ObservationAwareBaggageThreadLocalAccessor.baggageScopeClosingScope(entry, scope, (BaggageInScope)baggage);
        }
        return scope;
    }

    @NonNull
    private static BaggageAndScope baggageScopeClosingScope(Map.Entry<String, String> entry, BaggageAndScope scope, BaggageInScope baggage) {
        if (scope == null) {
            return ObservationAwareBaggageThreadLocalAccessor.scopeClosingBaggageAndScope(entry, baggage);
        }
        return ObservationAwareBaggageThreadLocalAccessor.scopeClosingBaggageAndScope(entry, baggage).andThen((Consumer)scope);
    }

    private static BaggageAndScope scopeClosingBaggageAndScope(Map.Entry<String, String> entry, BaggageInScope baggage) {
        return new BaggageAndScope(bs -> {
            if (log.isTraceEnabled()) {
                log.trace("Closing baggage [" + baggage + "] hashcode [" + baggage.hashCode() + "]");
            }
            baggage.close();
        }, entry);
    }

    public void setValue() {
        BaggageAndScope previousScope = this.baggageInScope.get(Thread.currentThread());
        if (log.isTraceEnabled()) {
            log.trace("setValue to empty baggage scope, current baggage scope [" + previousScope + "]");
        }
        if (previousScope == null) {
            if (log.isTraceEnabled()) {
                log.trace("No action to perform");
            }
            return;
        }
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(null);
        BaggageAndScope currentScope = new BaggageAndScope(o -> spanInScope.close());
        this.baggageInScope.put(Thread.currentThread(), this.scopeRestoringBaggageAndScope(currentScope, previousScope));
        if (log.isTraceEnabled()) {
            log.trace("setValue no args finished, current baggage scope [" + this.baggageInScope.get(Thread.currentThread()) + "]");
        }
    }

    private BaggageAndScope scopeRestoringBaggageAndScope(BaggageAndScope currentScope, BaggageAndScope previousScope) {
        return currentScope.andThen(o -> {
            if (previousScope != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Putting previous scope [" + previousScope + "]");
                }
                this.baggageInScope.put(Thread.currentThread(), previousScope);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("No previous scope to put, clearing the thread [" + Thread.currentThread() + "]");
                }
                this.baggageInScope.remove(Thread.currentThread());
            }
        });
    }

    void closeCurrentScope() {
        BaggageAndScope scope = this.baggageInScope.get(Thread.currentThread());
        if (log.isTraceEnabled()) {
            log.trace("Before close scope [" + scope + "]");
        }
        if (scope != null) {
            scope.accept((Object)null);
            if (log.isTraceEnabled()) {
                log.trace("After close scope [" + this.baggageInScope.get(Thread.currentThread()) + "]");
            }
        } else if (log.isTraceEnabled()) {
            log.trace("No action to perform");
        }
    }

    public void restore() {
        if (log.isTraceEnabled()) {
            log.trace("Restoring to empty baggage scope");
        }
        this.closeCurrentScope();
    }

    public void restore(BaggageToPropagate value) {
        if (log.isTraceEnabled()) {
            log.trace("Calling restore(value)");
        }
        this.closeCurrentScope();
    }

    @Deprecated
    public void reset() {
        if (log.isTraceEnabled()) {
            log.trace("Calling reset()");
        }
        super.reset();
    }

    static class BaggageAndScope
    implements Consumer<Object> {
        private static final InternalLogger log = InternalLoggerFactory.getInstance(BaggageInScope.class);
        private final Consumer<Object> consumer;
        private final Map.Entry<String, String> entry;

        BaggageAndScope(Consumer<Object> consumer, Map.Entry<String, String> entry) {
            this.consumer = consumer;
            this.entry = entry;
        }

        BaggageAndScope(Consumer<Object> consumer) {
            this.consumer = consumer;
            this.entry = null;
        }

        public String toString() {
            return "BaggageAndScope{consumer=" + this.consumer + ", entry=" + this.entry + '}';
        }

        @Override
        public void accept(Object o) {
            if (log.isTraceEnabled()) {
                log.trace("Accepting consumer [" + this + "]");
            }
            this.consumer.accept(o);
        }

        @NonNull
        public BaggageAndScope andThen(@NonNull Consumer<? super Object> after) {
            return new BaggageAndScope(Consumer.super.andThen(after), this.entry);
        }
    }
}

