/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.contextpropagation;

import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;

public class ObservationAwareSpanThreadLocalAccessor
implements ThreadLocalAccessor<Span> {
    public static final String KEY = "micrometer.tracing";
    private final Tracer tracer;
    private static final ObservationRegistry registry = ObservationRegistry.create();

    public ObservationAwareSpanThreadLocalAccessor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object key() {
        return KEY;
    }

    public Span getValue() {
        Observation currentObservation = registry.getCurrentObservation();
        if (currentObservation != null) {
            TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)currentObservation.getContextView().getOrDefault(TracingObservationHandler.TracingContext.class, (Object)new TracingObservationHandler.TracingContext());
            Span currentSpan = this.tracer.currentSpan();
            if (currentSpan != null && !currentSpan.equals(tracingContext.getSpan())) {
                return currentSpan;
            }
            return null;
        }
        return this.tracer.currentSpan();
    }

    public void setValue(Span value) {
        this.tracer.withSpan(value);
    }

    public void reset() {
        this.tracer.withSpan(null);
    }
}

