/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.BaggageView;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.test.simple.SimpleBaggageInScope;
import io.micrometer.tracing.test.simple.SimpleTraceContext;
import io.micrometer.tracing.test.simple.SimpleTracer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class SimpleBaggageManager
implements BaggageManager {
    private final Map<TraceContext, ThreadLocal<Set<SimpleBaggageInScope>>> baggagesByContext = new ConcurrentHashMap<TraceContext, ThreadLocal<Set<SimpleBaggageInScope>>>();
    private final SimpleTracer simpleTracer;
    private final List<String> remoteFields;

    public SimpleBaggageManager(SimpleTracer simpleTracer) {
        this.simpleTracer = simpleTracer;
        this.remoteFields = Collections.emptyList();
    }

    public SimpleBaggageManager(SimpleTracer simpleTracer, List<String> remoteFields) {
        this.simpleTracer = simpleTracer;
        this.remoteFields = remoteFields;
    }

    public Map<String, String> getAllBaggage() {
        TraceContext context = this.simpleTracer.currentTraceContext().context();
        if (context == null) {
            return Collections.emptyMap();
        }
        return this.getAllBaggageForCtx(context);
    }

    Map<String, String> getAllBaggageForCtx(TraceContext context) {
        Map<String, String> map = this.baggagesByContext.getOrDefault(context, ThreadLocal.withInitial(Collections::emptySet)).get().stream().filter(s -> s.get(context) != null).collect(Collectors.toMap(BaggageView::name, baggage -> baggage.get(context)));
        map.putAll(((SimpleTraceContext)context).baggageFromParent());
        return map;
    }

    public Baggage getBaggage(String name) {
        TraceContext context = this.simpleTracer.currentTraceContext().context();
        Baggage baggage = context == null ? null : this.getBaggage(context, name);
        return SimpleBaggageManager.baggageOrNoop(baggage);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        SimpleBaggageInScope simpleBaggageInScope = this.baggageForName(traceContext, name);
        return SimpleBaggageManager.baggageOrNoop(simpleBaggageInScope);
    }

    private static Baggage baggageOrNoop(@Nullable Baggage baggage) {
        if (baggage == null) {
            return Baggage.NOOP;
        }
        return baggage;
    }

    private @Nullable SimpleBaggageInScope baggageForName(@Nullable TraceContext traceContext, String name) {
        if (traceContext == null) {
            return null;
        }
        return this.baggagesByContext.getOrDefault(traceContext, ThreadLocal.withInitial(Collections::emptySet)).get().stream().filter(bag -> name.equalsIgnoreCase(bag.name())).findFirst().orElse(null);
    }

    @Deprecated
    public Baggage createBaggage(String name) {
        return this.createSimpleBaggage(name);
    }

    private Baggage createSimpleBaggage(String name) {
        TraceContext current = this.simpleTracer.currentTraceContext().context();
        SimpleBaggageInScope baggage = this.baggageForName(current, name);
        if (baggage == null) {
            ThreadLocal<Set> baggages = this.baggagesByContext.getOrDefault(current, ThreadLocal.withInitial(HashSet::new));
            baggage = new SimpleBaggageInScope(this.simpleTracer.currentTraceContext(), name, current);
            baggages.get().add(baggage);
            this.baggagesByContext.put(current, baggages);
        }
        return baggage;
    }

    @Deprecated
    public Baggage createBaggage(String name, String value) {
        Baggage baggage = this.createSimpleBaggage(name);
        baggage.set(value);
        return baggage;
    }

    public BaggageInScope createBaggageInScope(String name, String value) {
        return this.createSimpleBaggage(name).makeCurrent(value);
    }

    public BaggageInScope createBaggageInScope(TraceContext traceContext, String name, String value) {
        return this.createSimpleBaggage(name).makeCurrent(traceContext, value);
    }

    public Map<String, String> getAllBaggage(@Nullable TraceContext traceContext) {
        if (traceContext == null) {
            return this.getAllBaggage();
        }
        return this.getAllBaggageForCtx(traceContext);
    }

    public List<String> getBaggageFields() {
        return this.remoteFields;
    }
}

