/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.test.simple.SimpleSpan;
import io.micrometer.tracing.test.simple.SimpleTraceContext;
import io.micrometer.tracing.test.simple.SimpleTracer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class SimpleCurrentTraceContext
implements CurrentTraceContext {
    private final SimpleTracer simpleTracer;

    public SimpleCurrentTraceContext(SimpleTracer simpleTracer) {
        this.simpleTracer = simpleTracer;
    }

    public TraceContext context() {
        SimpleSpan span = this.simpleTracer.currentSpan();
        if (span != null) {
            return span.context();
        }
        return null;
    }

    public CurrentTraceContext.Scope newScope(TraceContext context) {
        if (context == null) {
            SimpleTracer.resetCurrentSpan();
            return CurrentTraceContext.Scope.NOOP;
        }
        SimpleSpan previous = SimpleTracer.getCurrentSpan();
        SimpleTracer.setCurrentSpan(context);
        Map<String, String> baggageFromParent = ((SimpleTraceContext)context).baggageFromParent();
        List<BaggageInScope> baggageInScope = baggageFromParent.entrySet().stream().map(entry -> this.simpleTracer.simpleBaggageManager.createBaggageInScope(context, (String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        return previous != null ? new RevertToPreviousScope(previous, baggageInScope) : new RevertToNullScope();
    }

    public CurrentTraceContext.Scope maybeScope(TraceContext context) {
        if (context == null) {
            SimpleTracer.resetCurrentSpan();
            return CurrentTraceContext.Scope.NOOP;
        }
        SimpleSpan current = SimpleTracer.getCurrentSpan();
        if (Objects.equals(current != null ? current.context() : current, context)) {
            return CurrentTraceContext.Scope.NOOP;
        }
        return this.newScope(context);
    }

    public <C> Callable<C> wrap(Callable<C> task) {
        return task;
    }

    public Runnable wrap(Runnable task) {
        return task;
    }

    public Executor wrap(Executor delegate) {
        return delegate;
    }

    public ExecutorService wrap(ExecutorService delegate) {
        return delegate;
    }

    private static final class RevertToPreviousScope
    implements CurrentTraceContext.Scope {
        final SimpleSpan previous;
        final List<BaggageInScope> baggageInScope;

        RevertToPreviousScope(SimpleSpan previous, List<BaggageInScope> baggageInScope) {
            this.previous = previous;
            this.baggageInScope = baggageInScope;
        }

        public void close() {
            SimpleTracer.setCurrentSpan(this.previous);
            this.baggageInScope.forEach(BaggageInScope::close);
        }
    }

    private static final class RevertToNullScope
    implements CurrentTraceContext.Scope {
        private RevertToNullScope() {
        }

        public void close() {
            SimpleTracer.resetCurrentSpan();
        }
    }
}

